/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.ServiceVersion;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.BuilderHelper;
import com.azure.data.tables.EntityHelper;
import com.azure.data.tables.TableClientBuilder;
import com.azure.data.tables.TableServiceVersion;
import com.azure.data.tables.implementation.AzureTableImpl;
import com.azure.data.tables.implementation.AzureTableImplBuilder;
import com.azure.data.tables.implementation.EntityPaged;
import com.azure.data.tables.implementation.TableEntityAccessHelper;
import com.azure.data.tables.implementation.TableItemAccessHelper;
import com.azure.data.tables.implementation.TableSasGenerator;
import com.azure.data.tables.implementation.TableSasUtils;
import com.azure.data.tables.implementation.TableTransactionActionResponseAccessHelper;
import com.azure.data.tables.implementation.TableUtils;
import com.azure.data.tables.implementation.TransactionalBatchImpl;
import com.azure.data.tables.implementation.models.OdataMetadataFormat;
import com.azure.data.tables.implementation.models.QueryOptions;
import com.azure.data.tables.implementation.models.ResponseFormat;
import com.azure.data.tables.implementation.models.SignedIdentifier;
import com.azure.data.tables.implementation.models.SignedIdentifierWrapper;
import com.azure.data.tables.implementation.models.TableEntityQueryResponse;
import com.azure.data.tables.implementation.models.TableProperties;
import com.azure.data.tables.implementation.models.TableResponseProperties;
import com.azure.data.tables.implementation.models.TableServiceJsonError;
import com.azure.data.tables.implementation.models.TablesGetAccessPolicyHeaders;
import com.azure.data.tables.implementation.models.TablesInsertEntityHeaders;
import com.azure.data.tables.implementation.models.TablesQueryEntitiesHeaders;
import com.azure.data.tables.implementation.models.TablesQueryEntityWithPartitionAndRowKeyHeaders;
import com.azure.data.tables.implementation.models.TablesSetAccessPolicyHeaders;
import com.azure.data.tables.implementation.models.TransactionalBatchAction;
import com.azure.data.tables.implementation.models.TransactionalBatchChangeSet;
import com.azure.data.tables.implementation.models.TransactionalBatchRequestBody;
import com.azure.data.tables.implementation.models.TransactionalBatchSubRequest;
import com.azure.data.tables.implementation.models.TransactionalBatchSubmitBatchHeaders;
import com.azure.data.tables.models.ListEntitiesOptions;
import com.azure.data.tables.models.TableAccessPolicies;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.TableEntityUpdateMode;
import com.azure.data.tables.models.TableItem;
import com.azure.data.tables.models.TableServiceException;
import com.azure.data.tables.models.TableSignedIdentifier;
import com.azure.data.tables.models.TableTransactionAction;
import com.azure.data.tables.models.TableTransactionActionResponse;
import com.azure.data.tables.models.TableTransactionFailedException;
import com.azure.data.tables.models.TableTransactionResult;
import com.azure.data.tables.sas.TableSasSignatureValues;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@ServiceClient(builder=TableClientBuilder.class)
public final class TableClient {
    private static final ExecutorService THREAD_POOL = TableUtils.getThreadPoolWithShutdownHook();
    private final ClientLogger logger = new ClientLogger(TableClient.class);
    private final String tableName;
    private final AzureTableImpl tablesImplementation;
    private final TransactionalBatchImpl transactionalBatchImplementation;
    private final String accountName;
    private final String tableEndpoint;
    private final HttpPipeline pipeline;
    private final TableClient transactionalBatchClient;

    TableClient(String tableName, HttpPipeline pipeline, String serviceUrl, TableServiceVersion serviceVersion, SerializerAdapter tablesSerializer, SerializerAdapter transactionalBatchSerializer) {
        try {
            if (tableName == null) {
                throw new NullPointerException("'tableName' must not be null to create TableClient.");
            }
            if (tableName.isEmpty()) {
                throw new IllegalArgumentException("'tableName' must not be empty to create a TableClient.");
            }
            URI uri = URI.create(serviceUrl);
            this.accountName = uri.getHost().split("\\.", 2)[0];
            this.tableEndpoint = uri.resolve("/" + tableName).toString();
            this.logger.verbose("Table Service URI: {}", new Object[]{uri});
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            throw this.logger.logExceptionAsError(ex);
        }
        this.tablesImplementation = new AzureTableImplBuilder().url(serviceUrl).serializerAdapter(tablesSerializer).pipeline(pipeline).version(serviceVersion.getVersion()).buildClient();
        this.transactionalBatchImplementation = new TransactionalBatchImpl(this.tablesImplementation, transactionalBatchSerializer);
        this.tableName = tableName;
        this.pipeline = this.tablesImplementation.getHttpPipeline();
        this.transactionalBatchClient = new TableClient(this, serviceVersion, tablesSerializer);
    }

    TableClient(TableClient client, ServiceVersion serviceVersion, SerializerAdapter tablesSerializer) {
        this.accountName = client.getAccountName();
        this.tableEndpoint = client.getTableEndpoint();
        this.pipeline = BuilderHelper.buildNullClientPipeline();
        this.tablesImplementation = new AzureTableImplBuilder().url(client.getTablesImplementation().getUrl()).serializerAdapter(tablesSerializer).pipeline(this.pipeline).version(serviceVersion.getVersion()).buildClient();
        this.tableName = client.getTableName();
        this.transactionalBatchImplementation = null;
        this.transactionalBatchClient = null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getTableEndpoint() {
        return this.tableEndpoint;
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    AzureTableImpl getTablesImplementation() {
        return this.tablesImplementation;
    }

    public TableServiceVersion getServiceVersion() {
        return TableServiceVersion.fromString(this.tablesImplementation.getVersion());
    }

    public String generateSas(TableSasSignatureValues tableSasSignatureValues) {
        AzureNamedKeyCredential azureNamedKeyCredential = TableSasUtils.extractNamedKeyCredential(this.getHttpPipeline());
        if (azureNamedKeyCredential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot generate a SAS token with a client that is not authenticated with an AzureNamedKeyCredential."));
        }
        return new TableSasGenerator(tableSasSignatureValues, this.getTableName(), azureNamedKeyCredential).getSas();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableItem createTable() {
        return (TableItem)this.createTableWithResponse(null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableItem> createTableWithResponse(Duration timeout, Context context) {
        TableProperties properties = new TableProperties().setTableName(this.tableName);
        Supplier callable = () -> new SimpleResponse(this.tablesImplementation.getTables().createWithResponse(properties, null, ResponseFormat.RETURN_NO_CONTENT, null, context), (Object)TableItemAccessHelper.createItem(new TableResponseProperties().setTableName(this.tableName)));
        return TableUtils.callWithOptionalTimeout(callable, THREAD_POOL, timeout, this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTable() {
        this.deleteTableWithResponse(null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTableWithResponse(Duration timeout, Context context) {
        Supplier<Response> callable = () -> new SimpleResponse(this.tablesImplementation.getTables().deleteWithResponse(this.tableName, null, context), null);
        try {
            return TableUtils.hasTimeout(timeout) ? (Response)CoreUtils.getResultWithTimeout(THREAD_POOL.submit(callable::get), (Duration)timeout) : callable.get();
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw this.logger.logExceptionAsError(new RuntimeException(ex));
        }
        catch (RuntimeException ex) {
            Throwable except = TableUtils.mapThrowableToTableServiceException(ex);
            return this.swallow404Exception(except);
        }
    }

    private Response<Void> swallow404Exception(Throwable ex) {
        if (ex instanceof TableServiceException && ((TableServiceException)((Object)ex)).getResponse().getStatusCode() == 404) {
            return new SimpleResponse(((TableServiceException)((Object)ex)).getResponse().getRequest(), ((TableServiceException)((Object)ex)).getResponse().getStatusCode(), ((TableServiceException)((Object)ex)).getResponse().getHeaders(), null);
        }
        throw this.logger.logExceptionAsError((RuntimeException)TableUtils.mapThrowableToTableServiceException(ex));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createEntity(TableEntity entity) {
        this.createEntityWithResponse(entity, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createEntityWithResponse(TableEntity entity, Duration timeout, Context context) {
        if (entity == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'entity' cannot be null."));
        }
        EntityHelper.setPropertiesFromGetters(entity, this.logger);
        Supplier callable = () -> {
            ResponseBase<TablesInsertEntityHeaders, Map<String, Object>> response = this.tablesImplementation.getTables().insertEntityWithResponse(this.tableName, null, null, ResponseFormat.RETURN_NO_CONTENT, entity.getProperties(), null, context);
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        };
        return TableUtils.callWithOptionalTimeout(callable, THREAD_POOL, timeout, this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upsertEntity(TableEntity entity) {
        this.upsertEntityWithResponse(entity, null, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> upsertEntityWithResponse(TableEntity entity, TableEntityUpdateMode updateMode, Duration timeout, Context context) {
        if (entity == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'entity' cannot be null."));
        }
        String partitionKey = TableUtils.escapeSingleQuotes(entity.getPartitionKey());
        String rowKey = TableUtils.escapeSingleQuotes(entity.getRowKey());
        EntityHelper.setPropertiesFromGetters(entity, this.logger);
        Supplier callable = () -> {
            if (updateMode == TableEntityUpdateMode.REPLACE) {
                return this.tablesImplementation.getTables().updateEntityWithResponse(this.tableName, partitionKey, rowKey, null, null, null, entity.getProperties(), null, context);
            }
            return this.tablesImplementation.getTables().mergeEntityWithResponse(this.tableName, partitionKey, rowKey, null, null, null, entity.getProperties(), null, context);
        };
        return TableUtils.callWithOptionalTimeout(callable, THREAD_POOL, timeout, this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateEntity(TableEntity entity) {
        this.updateEntity(entity, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateEntity(TableEntity entity, TableEntityUpdateMode updateMode) {
        this.updateEntityWithResponse(entity, updateMode, false, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateEntityWithResponse(TableEntity entity, TableEntityUpdateMode updateMode, boolean ifUnchanged, Duration timeout, Context context) {
        if (entity == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'entity' cannot be null."));
        }
        String partitionKey = TableUtils.escapeSingleQuotes(entity.getPartitionKey());
        String rowKey = TableUtils.escapeSingleQuotes(entity.getRowKey());
        String eTag = ifUnchanged ? entity.getETag() : "*";
        EntityHelper.setPropertiesFromGetters(entity, this.logger);
        Supplier callable = () -> {
            if (updateMode == TableEntityUpdateMode.REPLACE) {
                return this.tablesImplementation.getTables().updateEntityWithResponse(this.tableName, partitionKey, rowKey, null, null, eTag, entity.getProperties(), null, context);
            }
            return this.tablesImplementation.getTables().mergeEntityWithResponse(this.tableName, partitionKey, rowKey, null, null, eTag, entity.getProperties(), null, context);
        };
        return TableUtils.callWithOptionalTimeout(callable, THREAD_POOL, timeout, this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteEntity(String partitionKey, String rowKey) {
        this.deleteEntityWithResponse(partitionKey, rowKey, null, false, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteEntity(TableEntity entity) {
        this.deleteEntityWithResponse(entity, false, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteEntityWithResponse(TableEntity entity, boolean ifUnchanged, Duration timeout, Context context) {
        return this.deleteEntityWithResponse(entity.getPartitionKey(), entity.getRowKey(), entity.getETag(), ifUnchanged, timeout, context);
    }

    private Response<Void> deleteEntityWithResponse(String partitionKey, String rowKey, String eTag, boolean ifUnchanged, Duration timeout, Context context) {
        String finalETag;
        String string = finalETag = ifUnchanged ? eTag : "*";
        if (partitionKey == null || rowKey == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'partitionKey' and 'rowKey' cannot be null"));
        }
        Supplier<Response> callable = () -> this.tablesImplementation.getTables().deleteEntityWithResponse(this.tableName, TableUtils.escapeSingleQuotes(partitionKey), TableUtils.escapeSingleQuotes(rowKey), finalETag, null, null, null, context);
        try {
            return TableUtils.hasTimeout(timeout) ? (Response)CoreUtils.getResultWithTimeout(THREAD_POOL.submit(callable::get), (Duration)timeout) : callable.get();
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw this.logger.logExceptionAsError(new RuntimeException(ex));
        }
        catch (RuntimeException ex) {
            return this.swallow404Exception(TableUtils.mapThrowableToTableServiceException(ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TableEntity> listEntities() {
        return this.listEntities(new ListEntitiesOptions(), null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TableEntity> listEntities(ListEntitiesOptions options, Duration timeout, Context context) {
        Supplier callable = () -> new PagedIterable(() -> this.listEntitiesFirstPage(context, options, TableEntity.class), token -> this.listEntitiesNextPage((String)token, context, options, (Class)TableEntity.class));
        return TableUtils.callIterableWithOptionalTimeout(callable, THREAD_POOL, timeout, this.logger);
    }

    private <T extends TableEntity> PagedResponse<T> listEntitiesFirstPage(Context context, ListEntitiesOptions options, Class<T> resultType) {
        return this.listEntities(null, null, context, options, resultType);
    }

    private <T extends TableEntity> PagedResponse<T> listEntitiesNextPage(String token, Context context, ListEntitiesOptions options, Class<T> resultType) {
        if (token == null) {
            return null;
        }
        try {
            String[] keys = TableUtils.getKeysFromToken(token);
            return this.listEntities(keys[0], keys[1], context, options, resultType);
        }
        catch (RuntimeException ex) {
            throw this.logger.logExceptionAsError(ex);
        }
    }

    private <T extends TableEntity> PagedResponse<T> listEntities(String nextPartitionKey, String nextRowKey, Context context, ListEntitiesOptions options, Class<T> resultType) {
        String select = null;
        if (options.getSelect() != null) {
            select = String.join((CharSequence)",", options.getSelect());
        }
        QueryOptions queryOptions = new QueryOptions().setFilter(options.getFilter()).setTop(options.getTop()).setSelect(select).setFormat(OdataMetadataFormat.APPLICATION_JSON_ODATA_FULLMETADATA);
        ResponseBase<TablesQueryEntitiesHeaders, TableEntityQueryResponse> response = this.tablesImplementation.getTables().queryEntitiesWithResponse(this.tableName, null, null, nextPartitionKey, nextRowKey, queryOptions, context);
        TableEntityQueryResponse tablesQueryEntityResponse = (TableEntityQueryResponse)response.getValue();
        if (tablesQueryEntityResponse == null) {
            return null;
        }
        List<Map<String, Object>> entityResponseValue = tablesQueryEntityResponse.getValue();
        if (entityResponseValue == null) {
            return null;
        }
        List entities = entityResponseValue.stream().map(TableEntityAccessHelper::createEntity).map(e -> EntityHelper.convertToSubclass(e, resultType, this.logger)).collect(Collectors.toList());
        return new EntityPaged((Response<TableEntityQueryResponse>)response, entities, ((TablesQueryEntitiesHeaders)response.getDeserializedHeaders()).getXMsContinuationNextPartitionKey(), ((TablesQueryEntitiesHeaders)response.getDeserializedHeaders()).getXMsContinuationNextRowKey());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableEntity getEntity(String partitionKey, String rowKey) {
        return (TableEntity)this.getEntityWithResponse(partitionKey, rowKey, null, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableEntity> getEntityWithResponse(String partitionKey, String rowKey, List<String> select, Duration timeout, Context context) {
        QueryOptions queryOptions = new QueryOptions().setFormat(OdataMetadataFormat.APPLICATION_JSON_ODATA_FULLMETADATA);
        if (select != null) {
            queryOptions.setSelect(String.join((CharSequence)",", select));
        }
        if (partitionKey == null || rowKey == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'partitionKey' and 'rowKey' cannot be null."));
        }
        Supplier callable = () -> {
            ResponseBase<TablesQueryEntityWithPartitionAndRowKeyHeaders, Map<String, Object>> response = this.tablesImplementation.getTables().queryEntityWithPartitionAndRowKeyWithResponse(this.tableName, TableUtils.escapeSingleQuotes(partitionKey), TableUtils.escapeSingleQuotes(rowKey), null, null, queryOptions, context);
            Map matchingEntity = (Map)response.getValue();
            if (matchingEntity == null || matchingEntity.isEmpty()) {
                this.logger.info("There was no matching entity. Table {}, partition key: {}, row key: {}.", new Object[]{this.tableName, partitionKey, rowKey});
                return null;
            }
            TableEntity entity = TableEntityAccessHelper.createEntity(matchingEntity);
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)EntityHelper.convertToSubclass(entity, TableEntity.class, this.logger));
        };
        return TableUtils.callWithOptionalTimeout(callable, THREAD_POOL, timeout, this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableAccessPolicies getAccessPolicies() {
        return (TableAccessPolicies)this.getAccessPoliciesWithResponse(null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableAccessPolicies> getAccessPoliciesWithResponse(Duration timeout, Context context) {
        Supplier callable = () -> {
            ResponseBase<TablesGetAccessPolicyHeaders, SignedIdentifierWrapper> response;
            return new SimpleResponse(response, (Object)new TableAccessPolicies((response = this.tablesImplementation.getTables().getAccessPolicyWithResponse(this.tableName, null, null, context)).getValue() == null ? null : ((SignedIdentifierWrapper)response.getValue()).items().stream().map(TableUtils::toTableSignedIdentifier).collect(Collectors.toList())));
        };
        return TableUtils.callWithOptionalTimeout(callable, THREAD_POOL, timeout, this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessPolicies(List<TableSignedIdentifier> tableSignedIdentifiers) {
        this.setAccessPoliciesWithResponse(tableSignedIdentifiers, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessPoliciesWithResponse(List<TableSignedIdentifier> tableSignedIdentifiers, Duration timeout, Context context) {
        List signedIdentifiers = null;
        if (tableSignedIdentifiers != null) {
            signedIdentifiers = tableSignedIdentifiers.stream().map(tableSignedIdentifier -> {
                SignedIdentifier signedIdentifier = TableUtils.toSignedIdentifier(tableSignedIdentifier);
                if (signedIdentifier != null) {
                    if (signedIdentifier.getAccessPolicy() != null && signedIdentifier.getAccessPolicy().getStart() != null) {
                        signedIdentifier.getAccessPolicy().setStart(signedIdentifier.getAccessPolicy().getStart().truncatedTo(ChronoUnit.SECONDS));
                    }
                    if (signedIdentifier.getAccessPolicy() != null && signedIdentifier.getAccessPolicy().getExpiry() != null) {
                        signedIdentifier.getAccessPolicy().setExpiry(signedIdentifier.getAccessPolicy().getExpiry().truncatedTo(ChronoUnit.SECONDS));
                    }
                }
                return signedIdentifier;
            }).collect(Collectors.toList());
        }
        List finalSignedIdentifiers = signedIdentifiers;
        Supplier callable = () -> {
            ResponseBase<TablesSetAccessPolicyHeaders, Void> response = this.tablesImplementation.getTables().setAccessPolicyWithResponse(this.tableName, null, null, finalSignedIdentifiers, context);
            return new SimpleResponse(response, (Object)((Void)response.getValue()));
        };
        return TableUtils.callWithOptionalTimeout(callable, THREAD_POOL, timeout, this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableTransactionResult submitTransaction(List<TableTransactionAction> transactionActions) {
        return (TableTransactionResult)this.submitTransactionWithResponse(transactionActions, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableTransactionResult> submitTransactionWithResponse(List<TableTransactionAction> transactionActions, Duration timeout, Context context) {
        if (transactionActions.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("A transaction must contain at least one operation."));
        }
        ArrayList<TransactionalBatchAction> operations = new ArrayList<TransactionalBatchAction>();
        for (TableTransactionAction transactionAction : transactionActions) {
            switch (transactionAction.getActionType()) {
                case CREATE: {
                    operations.add(new TransactionalBatchAction.CreateEntity(transactionAction.getEntity()));
                    break;
                }
                case UPSERT_MERGE: {
                    operations.add(new TransactionalBatchAction.UpsertEntity(transactionAction.getEntity(), TableEntityUpdateMode.MERGE));
                    break;
                }
                case UPSERT_REPLACE: {
                    operations.add(new TransactionalBatchAction.UpsertEntity(transactionAction.getEntity(), TableEntityUpdateMode.REPLACE));
                    break;
                }
                case UPDATE_MERGE: {
                    operations.add(new TransactionalBatchAction.UpdateEntity(transactionAction.getEntity(), TableEntityUpdateMode.MERGE, transactionAction.getIfUnchanged()));
                    break;
                }
                case UPDATE_REPLACE: {
                    operations.add(new TransactionalBatchAction.UpdateEntity(transactionAction.getEntity(), TableEntityUpdateMode.REPLACE, transactionAction.getIfUnchanged()));
                    break;
                }
                case DELETE: {
                    operations.add(new TransactionalBatchAction.DeleteEntity(transactionAction.getEntity(), transactionAction.getIfUnchanged()));
                    break;
                }
            }
        }
        Supplier<Response> callable = () -> {
            BiConsumer<TransactionalBatchRequestBody, RequestActionPair> accumulator = (body, pair) -> body.addChangeOperation(new TransactionalBatchSubRequest(pair.getAction(), pair.getRequest()));
            BiConsumer<TransactionalBatchRequestBody, TransactionalBatchRequestBody> combiner = (body1, body2) -> body2.getContents().forEach(req -> body1.addChangeOperation((TransactionalBatchSubRequest)req));
            TransactionalBatchRequestBody requestBody = operations.stream().map(op -> new RequestActionPair(op.prepareRequest(this.transactionalBatchClient), (TransactionalBatchAction)op)).collect(TransactionalBatchRequestBody::new, accumulator, combiner);
            ResponseBase<TransactionalBatchSubmitBatchHeaders, TableTransactionActionResponse[]> response = this.transactionalBatchImplementation.submitTransactionalBatchWithRestResponse(requestBody, null, context);
            Response<List<TableTransactionActionResponse>> parsedResponse = this.parseResponse(requestBody, response);
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new TableTransactionResult(transactionActions, (List)parsedResponse.getValue()));
        };
        try {
            return TableUtils.hasTimeout(timeout) ? (Response)CoreUtils.getResultWithTimeout(THREAD_POOL.submit(callable::get), (Duration)timeout) : callable.get();
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw this.logger.logExceptionAsError(new RuntimeException(ex));
        }
        catch (RuntimeException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)TableUtils.interpretException(ex));
        }
    }

    private Response<List<TableTransactionActionResponse>> parseResponse(TransactionalBatchRequestBody requestBody, ResponseBase<TransactionalBatchSubmitBatchHeaders, TableTransactionActionResponse[]> response) {
        TableServiceJsonError error = null;
        String errorMessage = null;
        TransactionalBatchChangeSet changes = null;
        TransactionalBatchAction failedAction = null;
        Integer failedIndex = null;
        if (requestBody.getContents().get(0) instanceof TransactionalBatchChangeSet) {
            changes = (TransactionalBatchChangeSet)requestBody.getContents().get(0);
        }
        for (int i = 0; i < ((TableTransactionActionResponse[])response.getValue()).length; ++i) {
            TableTransactionActionResponse subResponse = ((TableTransactionActionResponse[])response.getValue())[i];
            if (changes != null && changes.getContents().get(i) != null) {
                TableTransactionActionResponseAccessHelper.updateTableTransactionActionResponse(subResponse, ((TransactionalBatchSubRequest)changes.getContents().get(i)).getHttpRequest());
            }
            if (subResponse.getStatusCode() < 400 || error != null || errorMessage != null) continue;
            if (subResponse.getValue() instanceof TableServiceJsonError) {
                error = (TableServiceJsonError)subResponse.getValue();
                if (changes == null || error.getOdataError() == null || error.getOdataError().getMessage() == null || error.getOdataError().getMessage().getValue() == null) continue;
                String message = error.getOdataError().getMessage().getValue();
                try {
                    failedIndex = Integer.parseInt(message.substring(0, message.indexOf(":")));
                    failedAction = ((TransactionalBatchSubRequest)changes.getContents().get(failedIndex)).getOperation();
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            errorMessage = subResponse.getValue() instanceof String ? "The service returned the following data for the failed operation: " + subResponse.getValue() : "The service returned the following status code for the failed operation: " + subResponse.getStatusCode();
        }
        if (error != null || errorMessage != null) {
            String message = "An action within the operation failed, the transaction has been rolled back.";
            if (failedAction != null) {
                message = message + " The failed operation was: " + failedAction;
            } else if (errorMessage != null) {
                message = message + " " + errorMessage;
            }
            throw this.logger.logExceptionAsError(new RuntimeException((Throwable)((Object)new TableTransactionFailedException(message, null, TableUtils.toTableServiceError(error), failedIndex))));
        }
        return new SimpleResponse(response, Arrays.asList((TableTransactionActionResponse[])response.getValue()));
    }

    private static class RequestActionPair {
        private final HttpRequest request;
        private final TransactionalBatchAction action;

        RequestActionPair(HttpRequest request, TransactionalBatchAction action) {
            this.request = request;
            this.action = action;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public TransactionalBatchAction getAction() {
            return this.action;
        }
    }
}

