// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.tables.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Azure Analytics Logging settings.
 */
@Fluent
public final class TableServiceLogging implements XmlSerializable<TableServiceLogging> {
    /*
     * The version of Analytics to configure.
     */
    private String analyticsVersion;

    /*
     * Indicates whether all delete requests should be logged.
     */
    private boolean deleteLogged;

    /*
     * Indicates whether all read requests should be logged.
     */
    private boolean readLogged;

    /*
     * Indicates whether all write requests should be logged.
     */
    private boolean writeLogged;

    /*
     * The retention policy.
     */
    private TableServiceRetentionPolicy retentionPolicy;

    /**
     * Creates an instance of TableServiceLogging class.
     */
    public TableServiceLogging() {
    }

    /**
     * Get the analyticsVersion property: The version of Analytics to configure.
     * 
     * @return the analyticsVersion value.
     */
    public String getAnalyticsVersion() {
        return this.analyticsVersion;
    }

    /**
     * Set the analyticsVersion property: The version of Analytics to configure.
     * 
     * @param analyticsVersion the analyticsVersion value to set.
     * @return the TableServiceLogging object itself.
     */
    public TableServiceLogging setAnalyticsVersion(String analyticsVersion) {
        this.analyticsVersion = analyticsVersion;
        return this;
    }

    /**
     * Get the deleteLogged property: Indicates whether all delete requests should be logged.
     * 
     * @return the deleteLogged value.
     */
    public boolean isDeleteLogged() {
        return this.deleteLogged;
    }

    /**
     * Set the deleteLogged property: Indicates whether all delete requests should be logged.
     * 
     * @param deleteLogged the deleteLogged value to set.
     * @return the TableServiceLogging object itself.
     */
    public TableServiceLogging setDeleteLogged(boolean deleteLogged) {
        this.deleteLogged = deleteLogged;
        return this;
    }

    /**
     * Get the readLogged property: Indicates whether all read requests should be logged.
     * 
     * @return the readLogged value.
     */
    public boolean isReadLogged() {
        return this.readLogged;
    }

    /**
     * Set the readLogged property: Indicates whether all read requests should be logged.
     * 
     * @param readLogged the readLogged value to set.
     * @return the TableServiceLogging object itself.
     */
    public TableServiceLogging setReadLogged(boolean readLogged) {
        this.readLogged = readLogged;
        return this;
    }

    /**
     * Get the writeLogged property: Indicates whether all write requests should be logged.
     * 
     * @return the writeLogged value.
     */
    public boolean isWriteLogged() {
        return this.writeLogged;
    }

    /**
     * Set the writeLogged property: Indicates whether all write requests should be logged.
     * 
     * @param writeLogged the writeLogged value to set.
     * @return the TableServiceLogging object itself.
     */
    public TableServiceLogging setWriteLogged(boolean writeLogged) {
        this.writeLogged = writeLogged;
        return this;
    }

    /**
     * Get the retentionPolicy property: The retention policy.
     * 
     * @return the retentionPolicy value.
     */
    public TableServiceRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    /**
     * Set the retentionPolicy property: The retention policy.
     * 
     * @param retentionPolicy the retentionPolicy value to set.
     * @return the TableServiceLogging object itself.
     */
    public TableServiceLogging setRetentionPolicy(TableServiceRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Logging" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Version", this.analyticsVersion);
        xmlWriter.writeBooleanElement("Delete", this.deleteLogged);
        xmlWriter.writeBooleanElement("Read", this.readLogged);
        xmlWriter.writeBooleanElement("Write", this.writeLogged);
        xmlWriter.writeXml(this.retentionPolicy, "RetentionPolicy");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of TableServiceLogging from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of TableServiceLogging if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TableServiceLogging.
     */
    public static TableServiceLogging fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of TableServiceLogging from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of TableServiceLogging if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TableServiceLogging.
     */
    public static TableServiceLogging fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Logging" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            TableServiceLogging deserializedTableServiceLogging = new TableServiceLogging();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedTableServiceLogging.analyticsVersion = reader.getStringElement();
                } else if ("Delete".equals(elementName.getLocalPart())) {
                    deserializedTableServiceLogging.deleteLogged = reader.getBooleanElement();
                } else if ("Read".equals(elementName.getLocalPart())) {
                    deserializedTableServiceLogging.readLogged = reader.getBooleanElement();
                } else if ("Write".equals(elementName.getLocalPart())) {
                    deserializedTableServiceLogging.writeLogged = reader.getBooleanElement();
                } else if ("RetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedTableServiceLogging.retentionPolicy
                        = TableServiceRetentionPolicy.fromXml(reader, "RetentionPolicy");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedTableServiceLogging;
        });
    }
}
