// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.tables.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The retention policy.
 */
@Fluent
public final class TableServiceRetentionPolicy implements XmlSerializable<TableServiceRetentionPolicy> {
    /*
     * Indicates whether a retention policy is enabled for the service.
     */
    private boolean enabled;

    /*
     * Indicates the number of days that metrics or logging or soft-deleted data should be retained. All data older than
     * this value will be deleted.
     */
    private Integer daysToRetain;

    /**
     * Creates an instance of TableServiceRetentionPolicy class.
     */
    public TableServiceRetentionPolicy() {
    }

    /**
     * Get the enabled property: Indicates whether a retention policy is enabled for the service.
     * 
     * @return the enabled value.
     */
    public boolean isEnabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether a retention policy is enabled for the service.
     * 
     * @param enabled the enabled value to set.
     * @return the TableServiceRetentionPolicy object itself.
     */
    public TableServiceRetentionPolicy setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the daysToRetain property: Indicates the number of days that metrics or logging or soft-deleted data should
     * be retained. All data older than this value will be deleted.
     * 
     * @return the daysToRetain value.
     */
    public Integer getDaysToRetain() {
        return this.daysToRetain;
    }

    /**
     * Set the daysToRetain property: Indicates the number of days that metrics or logging or soft-deleted data should
     * be retained. All data older than this value will be deleted.
     * 
     * @param daysToRetain the daysToRetain value to set.
     * @return the TableServiceRetentionPolicy object itself.
     */
    public TableServiceRetentionPolicy setDaysToRetain(Integer daysToRetain) {
        this.daysToRetain = daysToRetain;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "RetentionPolicy" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeBooleanElement("Enabled", this.enabled);
        xmlWriter.writeNumberElement("Days", this.daysToRetain);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of TableServiceRetentionPolicy from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of TableServiceRetentionPolicy if the XmlReader was pointing to an instance of it, or null if
     * it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TableServiceRetentionPolicy.
     */
    public static TableServiceRetentionPolicy fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of TableServiceRetentionPolicy from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of TableServiceRetentionPolicy if the XmlReader was pointing to an instance of it, or null if
     * it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TableServiceRetentionPolicy.
     */
    public static TableServiceRetentionPolicy fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "RetentionPolicy" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            TableServiceRetentionPolicy deserializedTableServiceRetentionPolicy = new TableServiceRetentionPolicy();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Enabled".equals(elementName.getLocalPart())) {
                    deserializedTableServiceRetentionPolicy.enabled = reader.getBooleanElement();
                } else if ("Days".equals(elementName.getLocalPart())) {
                    deserializedTableServiceRetentionPolicy.daysToRetain = reader.getNullableElement(Integer::parseInt);
                } else {
                    reader.skipElement();
                }
            }

            return deserializedTableServiceRetentionPolicy;
        });
    }
}
