/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.implementation.models.TableResponseProperties;
import com.azure.data.tables.models.TableItem;
import java.util.function.Function;

public final class TableItemAccessHelper {
    private static Function<TableResponseProperties, TableItem> creator;

    public static void setTableItemCreator(Function<TableResponseProperties, TableItem> creator) {
        TableItemAccessHelper.creator = creator;
    }

    public static TableItem createItem(TableResponseProperties properties) {
        if (creator == null) {
            try {
                Class.forName(TableItem.class.getName(), true, TableItemAccessHelper.class.getClassLoader());
            }
            catch (ReflectiveOperationException ex) {
                throw new ClientLogger(TableItemAccessHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("Failed to load 'TableItem' class within 'TableItemAccessHelper'.", ex));
            }
        }
        assert (creator != null);
        return creator.apply(properties);
    }

    private TableItemAccessHelper() {
    }
}

