/*
 * Decompiled with CFR 0.152.
 */
package com.azure.digitaltwins.core;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.models.JsonPatchDocument;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.digitaltwins.core.DigitalTwinsServiceVersion;
import com.azure.digitaltwins.core.implementation.AzureDigitalTwinsAPIImpl;
import com.azure.digitaltwins.core.implementation.AzureDigitalTwinsAPIImplBuilder;
import com.azure.digitaltwins.core.implementation.converters.DigitalTwinsModelDataConverter;
import com.azure.digitaltwins.core.implementation.converters.EventRouteConverter;
import com.azure.digitaltwins.core.implementation.converters.IncomingRelationshipConverter;
import com.azure.digitaltwins.core.implementation.converters.OptionsConverter;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinModelsListOptions;
import com.azure.digitaltwins.core.implementation.models.EventRoute;
import com.azure.digitaltwins.core.implementation.models.IncomingRelationship;
import com.azure.digitaltwins.core.implementation.models.QueriesQueryTwinsHeaders;
import com.azure.digitaltwins.core.implementation.models.QuerySpecification;
import com.azure.digitaltwins.core.implementation.serializer.DeserializationHelpers;
import com.azure.digitaltwins.core.implementation.serializer.DigitalTwinsStringSerializer;
import com.azure.digitaltwins.core.implementation.serializer.SerializationHelpers;
import com.azure.digitaltwins.core.models.CreateOrReplaceDigitalTwinOptions;
import com.azure.digitaltwins.core.models.CreateOrReplaceRelationshipOptions;
import com.azure.digitaltwins.core.models.DeleteDigitalTwinOptions;
import com.azure.digitaltwins.core.models.DeleteRelationshipOptions;
import com.azure.digitaltwins.core.models.DigitalTwinsEventRoute;
import com.azure.digitaltwins.core.models.DigitalTwinsModelData;
import com.azure.digitaltwins.core.models.DigitalTwinsResponse;
import com.azure.digitaltwins.core.models.DigitalTwinsResponseHeaders;
import com.azure.digitaltwins.core.models.ListDigitalTwinsEventRoutesOptions;
import com.azure.digitaltwins.core.models.ListModelsOptions;
import com.azure.digitaltwins.core.models.PublishComponentTelemetryOptions;
import com.azure.digitaltwins.core.models.PublishTelemetryOptions;
import com.azure.digitaltwins.core.models.QueryOptions;
import com.azure.digitaltwins.core.models.UpdateComponentOptions;
import com.azure.digitaltwins.core.models.UpdateDigitalTwinOptions;
import com.azure.digitaltwins.core.models.UpdateRelationshipOptions;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class DigitalTwinsAsyncClient {
    private static final ClientLogger logger = new ClientLogger(DigitalTwinsAsyncClient.class);
    private final ObjectMapper mapper;
    private final DigitalTwinsServiceVersion serviceVersion;
    private final AzureDigitalTwinsAPIImpl protocolLayer;
    private static final Boolean includeModelDefinitionOnGet = true;
    private final com.azure.core.util.serializer.JsonSerializer serializer;
    private static final String DIGITAL_TWINS_TRACING_NAMESPACE_VALUE = "Microsoft.DigitalTwins";
    private Function<PagedResponse<IncomingRelationship>, PagedResponse<com.azure.digitaltwins.core.models.IncomingRelationship>> pagedIncomingRelationshipMappingFunction = pagedIncomingRelationshipResponse -> {
        List convertedList = pagedIncomingRelationshipResponse.getValue().stream().map(IncomingRelationshipConverter::map).filter(Objects::nonNull).collect(Collectors.toList());
        return new PagedResponseBase(pagedIncomingRelationshipResponse.getRequest(), pagedIncomingRelationshipResponse.getStatusCode(), pagedIncomingRelationshipResponse.getHeaders(), convertedList, (String)pagedIncomingRelationshipResponse.getContinuationToken(), ((PagedResponseBase)pagedIncomingRelationshipResponse).getDeserializedHeaders());
    };
    private final Function<PagedResponse<EventRoute>, PagedResponse<DigitalTwinsEventRoute>> pagedEventRouteMappingFunction = pagedEventRouteResponse -> {
        List convertedList = pagedEventRouteResponse.getValue().stream().map(EventRouteConverter::map).filter(Objects::nonNull).collect(Collectors.toList());
        return new PagedResponseBase(pagedEventRouteResponse.getRequest(), pagedEventRouteResponse.getStatusCode(), pagedEventRouteResponse.getHeaders(), convertedList, (String)pagedEventRouteResponse.getContinuationToken(), ((PagedResponseBase)pagedEventRouteResponse).getDeserializedHeaders());
    };

    DigitalTwinsAsyncClient(String serviceEndpoint, HttpPipeline pipeline, DigitalTwinsServiceVersion serviceVersion, com.azure.core.util.serializer.JsonSerializer jsonSerializer) {
        SimpleModule stringModule = new SimpleModule("String Serializer");
        JacksonAdapter jacksonAdapter = new JacksonAdapter();
        this.mapper = jacksonAdapter.serializer();
        stringModule.addSerializer((JsonSerializer)new DigitalTwinsStringSerializer(String.class, this.mapper));
        jacksonAdapter.serializer().registerModule((Module)stringModule);
        this.serviceVersion = serviceVersion;
        this.serializer = jsonSerializer;
        this.protocolLayer = new AzureDigitalTwinsAPIImplBuilder().host(serviceEndpoint).pipeline(pipeline).serializerAdapter((SerializerAdapter)jacksonAdapter).buildClient();
    }

    public DigitalTwinsServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public <T> Mono<T> createOrReplaceDigitalTwin(String digitalTwinId, T digitalTwin, Class<T> clazz) {
        return this.createOrReplaceDigitalTwinWithResponse(digitalTwinId, digitalTwin, clazz, null).map(DigitalTwinsResponse::getValue);
    }

    public <T> Mono<DigitalTwinsResponse<T>> createOrReplaceDigitalTwinWithResponse(String digitalTwinId, T digitalTwin, Class<T> clazz, CreateOrReplaceDigitalTwinOptions options) {
        return FluxUtil.withContext(context -> this.createOrReplaceDigitalTwinWithResponse(digitalTwinId, digitalTwin, clazz, options, (Context)context));
    }

    <T> Mono<DigitalTwinsResponse<T>> createOrReplaceDigitalTwinWithResponse(String digitalTwinId, T digitalTwin, Class<T> clazz, CreateOrReplaceDigitalTwinOptions options, Context context) {
        return this.protocolLayer.getDigitalTwins().addWithResponseAsync(digitalTwinId, digitalTwin, OptionsConverter.toProtocolLayerOptions(options), context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).flatMap(response -> {
            Object genericResponse;
            try {
                genericResponse = DeserializationHelpers.deserializeObject(this.mapper, response.getValue(), clazz, this.serializer);
            }
            catch (JsonProcessingException e) {
                logger.error("JsonProcessingException occurred while deserializing the response: ", new Object[]{e});
                return Mono.error((Throwable)e);
            }
            DigitalTwinsResponseHeaders twinHeaders = (DigitalTwinsResponseHeaders)this.mapper.convertValue(response.getDeserializedHeaders(), DigitalTwinsResponseHeaders.class);
            return Mono.just(new DigitalTwinsResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), genericResponse, twinHeaders));
        });
    }

    public <T> Mono<T> getDigitalTwin(String digitalTwinId, Class<T> clazz) {
        return this.getDigitalTwinWithResponse(digitalTwinId, clazz).map(DigitalTwinsResponse::getValue);
    }

    public <T> Mono<DigitalTwinsResponse<T>> getDigitalTwinWithResponse(String digitalTwinId, Class<T> clazz) {
        return FluxUtil.withContext(context -> this.getDigitalTwinWithResponse(digitalTwinId, clazz, (Context)context));
    }

    <T> Mono<DigitalTwinsResponse<T>> getDigitalTwinWithResponse(String digitalTwinId, Class<T> clazz, Context context) {
        return this.protocolLayer.getDigitalTwins().getByIdWithResponseAsync(digitalTwinId, null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).flatMap(response -> {
            Object genericResponse;
            try {
                genericResponse = DeserializationHelpers.deserializeObject(this.mapper, response.getValue(), clazz, this.serializer);
            }
            catch (JsonProcessingException e) {
                logger.error("JsonProcessingException occurred while deserializing the digital twin get response: ", new Object[]{e});
                return Mono.error((Throwable)e);
            }
            DigitalTwinsResponseHeaders twinHeaders = (DigitalTwinsResponseHeaders)this.mapper.convertValue(response.getDeserializedHeaders(), DigitalTwinsResponseHeaders.class);
            return Mono.just(new DigitalTwinsResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), genericResponse, twinHeaders));
        });
    }

    public Mono<Void> updateDigitalTwin(String digitalTwinId, JsonPatchDocument jsonPatch) {
        return this.updateDigitalTwinWithResponse(digitalTwinId, jsonPatch, null).flatMap(voidResponse -> Mono.empty());
    }

    public Mono<DigitalTwinsResponse<Void>> updateDigitalTwinWithResponse(String digitalTwinId, JsonPatchDocument jsonPatch, UpdateDigitalTwinOptions options) {
        return FluxUtil.withContext(context -> this.updateDigitalTwinWithResponse(digitalTwinId, jsonPatch, options, (Context)context));
    }

    Mono<DigitalTwinsResponse<Void>> updateDigitalTwinWithResponse(String digitalTwinId, JsonPatchDocument jsonPatch, UpdateDigitalTwinOptions options, Context context) {
        return this.protocolLayer.getDigitalTwins().updateWithResponseAsync(digitalTwinId, jsonPatch, OptionsConverter.toProtocolLayerOptions(options), context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(response -> {
            DigitalTwinsResponseHeaders twinHeaders = (DigitalTwinsResponseHeaders)this.mapper.convertValue(response.getDeserializedHeaders(), DigitalTwinsResponseHeaders.class);
            return new DigitalTwinsResponse<Void>(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Void)response.getValue(), twinHeaders);
        });
    }

    public Mono<Void> deleteDigitalTwin(String digitalTwinId) {
        return this.deleteDigitalTwinWithResponse(digitalTwinId, null).flatMap(voidResponse -> Mono.empty());
    }

    public Mono<Response<Void>> deleteDigitalTwinWithResponse(String digitalTwinId, DeleteDigitalTwinOptions options) {
        return FluxUtil.withContext(context -> this.deleteDigitalTwinWithResponse(digitalTwinId, options, (Context)context));
    }

    Mono<Response<Void>> deleteDigitalTwinWithResponse(String digitalTwinId, DeleteDigitalTwinOptions options, Context context) {
        return this.protocolLayer.getDigitalTwins().deleteWithResponseAsync(digitalTwinId, OptionsConverter.toProtocolLayerOptions(options), context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE));
    }

    public <T> Mono<T> createOrReplaceRelationship(String digitalTwinId, String relationshipId, T relationship, Class<T> clazz) {
        return this.createOrReplaceRelationshipWithResponse(digitalTwinId, relationshipId, relationship, clazz, null).map(DigitalTwinsResponse::getValue);
    }

    public <T> Mono<DigitalTwinsResponse<T>> createOrReplaceRelationshipWithResponse(String digitalTwinId, String relationshipId, T relationship, Class<T> clazz, CreateOrReplaceRelationshipOptions options) {
        return FluxUtil.withContext(context -> this.createOrReplaceRelationshipWithResponse(digitalTwinId, relationshipId, relationship, clazz, options, (Context)context));
    }

    <T> Mono<DigitalTwinsResponse<T>> createOrReplaceRelationshipWithResponse(String digitalTwinId, String relationshipId, T relationship, Class<T> clazz, CreateOrReplaceRelationshipOptions options, Context context) {
        return this.protocolLayer.getDigitalTwins().addRelationshipWithResponseAsync(digitalTwinId, relationshipId, relationship, OptionsConverter.toProtocolLayerOptions(options), context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).flatMap(response -> {
            Object genericResponse;
            try {
                genericResponse = DeserializationHelpers.deserializeObject(this.mapper, response.getValue(), clazz, this.serializer);
            }
            catch (JsonProcessingException e) {
                logger.error("JsonProcessingException occurred while deserializing the create relationship response: ", new Object[]{e});
                return Mono.error((Throwable)e);
            }
            DigitalTwinsResponseHeaders twinHeaders = (DigitalTwinsResponseHeaders)this.mapper.convertValue(response.getDeserializedHeaders(), DigitalTwinsResponseHeaders.class);
            return Mono.just(new DigitalTwinsResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), genericResponse, twinHeaders));
        });
    }

    public <T> Mono<T> getRelationship(String digitalTwinId, String relationshipId, Class<T> clazz) {
        return this.getRelationshipWithResponse(digitalTwinId, relationshipId, clazz).map(DigitalTwinsResponse::getValue);
    }

    public <T> Mono<DigitalTwinsResponse<T>> getRelationshipWithResponse(String digitalTwinId, String relationshipId, Class<T> clazz) {
        return FluxUtil.withContext(context -> this.getRelationshipWithResponse(digitalTwinId, relationshipId, clazz, (Context)context));
    }

    <T> Mono<DigitalTwinsResponse<T>> getRelationshipWithResponse(String digitalTwinId, String relationshipId, Class<T> clazz, Context context) {
        return this.protocolLayer.getDigitalTwins().getRelationshipByIdWithResponseAsync(digitalTwinId, relationshipId, null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).flatMap(response -> {
            Object genericResponse;
            try {
                genericResponse = DeserializationHelpers.deserializeObject(this.mapper, response.getValue(), clazz, this.serializer);
            }
            catch (JsonProcessingException e) {
                logger.error("JsonProcessingException occurred while deserializing the get relationship response: ", new Object[]{e});
                return Mono.error((Throwable)e);
            }
            DigitalTwinsResponseHeaders twinHeaders = (DigitalTwinsResponseHeaders)this.mapper.convertValue(response.getDeserializedHeaders(), DigitalTwinsResponseHeaders.class);
            return Mono.just(new DigitalTwinsResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), genericResponse, twinHeaders));
        });
    }

    public Mono<Void> updateRelationship(String digitalTwinId, String relationshipId, JsonPatchDocument jsonPatch) {
        return this.updateRelationshipWithResponse(digitalTwinId, relationshipId, jsonPatch, null).flatMap(voidResponse -> Mono.empty());
    }

    public Mono<DigitalTwinsResponse<Void>> updateRelationshipWithResponse(String digitalTwinId, String relationshipId, JsonPatchDocument jsonPatch, UpdateRelationshipOptions options) {
        return FluxUtil.withContext(context -> this.updateRelationshipWithResponse(digitalTwinId, relationshipId, jsonPatch, options, (Context)context));
    }

    Mono<DigitalTwinsResponse<Void>> updateRelationshipWithResponse(String digitalTwinId, String relationshipId, JsonPatchDocument jsonPatch, UpdateRelationshipOptions options, Context context) {
        return this.protocolLayer.getDigitalTwins().updateRelationshipWithResponseAsync(digitalTwinId, relationshipId, jsonPatch, OptionsConverter.toProtocolLayerOptions(options), context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(response -> {
            DigitalTwinsResponseHeaders twinHeaders = (DigitalTwinsResponseHeaders)this.mapper.convertValue(response.getDeserializedHeaders(), DigitalTwinsResponseHeaders.class);
            return new DigitalTwinsResponse<Void>(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Void)response.getValue(), twinHeaders);
        });
    }

    public Mono<Void> deleteRelationship(String digitalTwinId, String relationshipId) {
        return this.deleteRelationshipWithResponse(digitalTwinId, relationshipId, null).flatMap(voidResponse -> Mono.empty());
    }

    public Mono<Response<Void>> deleteRelationshipWithResponse(String digitalTwinId, String relationshipId, DeleteRelationshipOptions options) {
        return FluxUtil.withContext(context -> this.deleteRelationshipWithResponse(digitalTwinId, relationshipId, options, (Context)context));
    }

    Mono<Response<Void>> deleteRelationshipWithResponse(String digitalTwinId, String relationshipId, DeleteRelationshipOptions options, Context context) {
        return this.protocolLayer.getDigitalTwins().deleteRelationshipWithResponseAsync(digitalTwinId, relationshipId, OptionsConverter.toProtocolLayerOptions(options), context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE));
    }

    public <T> PagedFlux<T> listRelationships(String digitalTwinId, Class<T> clazz) {
        return this.listRelationships(digitalTwinId, null, clazz);
    }

    public <T> PagedFlux<T> listRelationships(String digitalTwinId, String relationshipName, Class<T> clazz) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listRelationshipsFirstPage(digitalTwinId, relationshipName, clazz, (Context)context)), nextLink -> FluxUtil.withContext(context -> this.listRelationshipsNextPage((String)nextLink, clazz, (Context)context)));
    }

    <T> PagedFlux<T> listRelationships(String digitalTwinId, String relationshipName, Class<T> clazz, Context context) {
        return new PagedFlux(() -> this.listRelationshipsFirstPage(digitalTwinId, relationshipName, clazz, context), nextLink -> this.listRelationshipsNextPage((String)nextLink, clazz, context));
    }

    <T> Mono<PagedResponse<T>> listRelationshipsFirstPage(String digitalTwinId, String relationshipName, Class<T> clazz, Context context) {
        return this.protocolLayer.getDigitalTwins().listRelationshipsSinglePageAsync(digitalTwinId, relationshipName, null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(objectPagedResponse -> {
            List list = objectPagedResponse.getValue().stream().map(object -> {
                try {
                    return DeserializationHelpers.deserializeObject(this.mapper, object, clazz, this.serializer);
                }
                catch (JsonProcessingException e) {
                    logger.error("JsonProcessingException occurred while deserializing the list relationship response: ", new Object[]{e});
                    throw new RuntimeException("JsonProcessingException occurred while deserializing the list relationship response", e);
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return new PagedResponseBase(objectPagedResponse.getRequest(), objectPagedResponse.getStatusCode(), objectPagedResponse.getHeaders(), list, (String)objectPagedResponse.getContinuationToken(), ((PagedResponseBase)objectPagedResponse).getDeserializedHeaders());
        });
    }

    <T> Mono<PagedResponse<T>> listRelationshipsNextPage(String nextLink, Class<T> clazz, Context context) {
        return this.protocolLayer.getDigitalTwins().listRelationshipsNextSinglePageAsync(nextLink, null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(objectPagedResponse -> {
            List stringList = objectPagedResponse.getValue().stream().map(object -> {
                try {
                    return DeserializationHelpers.deserializeObject(this.mapper, object, clazz, this.serializer);
                }
                catch (JsonProcessingException e) {
                    logger.error("JsonProcessingException occurred while deserializing the list relationship response: ", new Object[]{e});
                    throw new RuntimeException("JsonProcessingException occurred while deserializing the list relationship response", e);
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return new PagedResponseBase(objectPagedResponse.getRequest(), objectPagedResponse.getStatusCode(), objectPagedResponse.getHeaders(), stringList, (String)objectPagedResponse.getContinuationToken(), ((PagedResponseBase)objectPagedResponse).getDeserializedHeaders());
        });
    }

    public PagedFlux<com.azure.digitaltwins.core.models.IncomingRelationship> listIncomingRelationships(String digitalTwinId) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listIncomingRelationshipsFirstPageAsync(digitalTwinId, (Context)context)), nextLink -> FluxUtil.withContext(context -> this.listIncomingRelationshipsNextSinglePageAsync((String)nextLink, (Context)context)));
    }

    PagedFlux<com.azure.digitaltwins.core.models.IncomingRelationship> listIncomingRelationships(String digitalTwinId, Context context) {
        return new PagedFlux(() -> this.listIncomingRelationshipsFirstPageAsync(digitalTwinId, context), nextLink -> this.listIncomingRelationshipsNextSinglePageAsync((String)nextLink, context));
    }

    Mono<PagedResponse<com.azure.digitaltwins.core.models.IncomingRelationship>> listIncomingRelationshipsFirstPageAsync(String digitalTwinId, Context context) {
        return this.protocolLayer.getDigitalTwins().listIncomingRelationshipsSinglePageAsync(digitalTwinId, null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(this.pagedIncomingRelationshipMappingFunction);
    }

    Mono<PagedResponse<com.azure.digitaltwins.core.models.IncomingRelationship>> listIncomingRelationshipsNextSinglePageAsync(String nextLink, Context context) {
        return this.protocolLayer.getDigitalTwins().listIncomingRelationshipsNextSinglePageAsync(nextLink, null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(this.pagedIncomingRelationshipMappingFunction);
    }

    public Mono<Iterable<DigitalTwinsModelData>> createModels(Iterable<String> dtdlModels) {
        return this.createModelsWithResponse(dtdlModels).map(Response::getValue);
    }

    public Mono<Response<Iterable<DigitalTwinsModelData>>> createModelsWithResponse(Iterable<String> dtdlModels) {
        return FluxUtil.withContext(context -> this.createModelsWithResponse(dtdlModels, (Context)context));
    }

    Mono<Response<Iterable<DigitalTwinsModelData>>> createModelsWithResponse(Iterable<String> dtdlModels, Context context) {
        ArrayList<Object> modelsPayload = new ArrayList<Object>();
        for (String model : dtdlModels) {
            try {
                modelsPayload.add(this.mapper.readValue(model, Object.class));
            }
            catch (JsonProcessingException e) {
                logger.error("Could not parse the model payload [%s]: %s", new Object[]{model, e});
                return Mono.error((Throwable)e);
            }
        }
        return this.protocolLayer.getDigitalTwinModels().addWithResponseAsync(modelsPayload, null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(listResponse -> {
            Iterable convertedList = ((List)listResponse.getValue()).stream().map(DigitalTwinsModelDataConverter::map).collect(Collectors.toList());
            return new SimpleResponse(listResponse.getRequest(), listResponse.getStatusCode(), listResponse.getHeaders(), (Object)convertedList);
        });
    }

    public Mono<DigitalTwinsModelData> getModel(String modelId) {
        return this.getModelWithResponse(modelId).map(Response::getValue);
    }

    public Mono<Response<DigitalTwinsModelData>> getModelWithResponse(String modelId) {
        return FluxUtil.withContext(context -> this.getModelWithResponse(modelId, (Context)context));
    }

    Mono<Response<DigitalTwinsModelData>> getModelWithResponse(String modelId, Context context) {
        return this.protocolLayer.getDigitalTwinModels().getByIdWithResponseAsync(modelId, includeModelDefinitionOnGet, null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(response -> {
            com.azure.digitaltwins.core.implementation.models.DigitalTwinsModelData modelData = (com.azure.digitaltwins.core.implementation.models.DigitalTwinsModelData)response.getValue();
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)DigitalTwinsModelDataConverter.map(modelData));
        });
    }

    public PagedFlux<DigitalTwinsModelData> listModels() {
        return this.listModels(null);
    }

    public PagedFlux<DigitalTwinsModelData> listModels(ListModelsOptions options) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listModelsSinglePageAsync(options, (Context)context)), nextLink -> FluxUtil.withContext(context -> this.listModelsNextSinglePageAsync((String)nextLink, options, (Context)context)));
    }

    PagedFlux<DigitalTwinsModelData> listModels(ListModelsOptions options, Context context) {
        return new PagedFlux(() -> this.listModelsSinglePageAsync(options, context), nextLink -> this.listModelsNextSinglePageAsync((String)nextLink, options, context));
    }

    Mono<PagedResponse<DigitalTwinsModelData>> listModelsSinglePageAsync(ListModelsOptions options, Context context) {
        List<String> getDependenciesFor = null;
        boolean includeModelDefinition = true;
        DigitalTwinModelsListOptions protocolLayerOptions = OptionsConverter.toProtocolLayerOptions(options);
        if (options != null) {
            getDependenciesFor = options.getDependenciesFor();
            includeModelDefinition = options.getIncludeModelDefinition();
        }
        return this.protocolLayer.getDigitalTwinModels().listSinglePageAsync(getDependenciesFor, includeModelDefinition, protocolLayerOptions, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(objectPagedResponse -> {
            List convertedList = objectPagedResponse.getValue().stream().map(DigitalTwinsModelDataConverter::map).filter(Objects::nonNull).collect(Collectors.toList());
            return new PagedResponseBase(objectPagedResponse.getRequest(), objectPagedResponse.getStatusCode(), objectPagedResponse.getHeaders(), convertedList, (String)objectPagedResponse.getContinuationToken(), ((PagedResponseBase)objectPagedResponse).getDeserializedHeaders());
        });
    }

    Mono<PagedResponse<DigitalTwinsModelData>> listModelsNextSinglePageAsync(String nextLink, ListModelsOptions options, Context context) {
        DigitalTwinModelsListOptions protocolLayerOptions = null;
        if (options != null) {
            protocolLayerOptions = new DigitalTwinModelsListOptions().setMaxItemsPerPage(options.getMaxItemsPerPage());
        }
        return this.protocolLayer.getDigitalTwinModels().listNextSinglePageAsync(nextLink, protocolLayerOptions, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(objectPagedResponse -> {
            List convertedList = objectPagedResponse.getValue().stream().map(DigitalTwinsModelDataConverter::map).filter(Objects::nonNull).collect(Collectors.toList());
            return new PagedResponseBase(objectPagedResponse.getRequest(), objectPagedResponse.getStatusCode(), objectPagedResponse.getHeaders(), convertedList, (String)objectPagedResponse.getContinuationToken(), ((PagedResponseBase)objectPagedResponse).getDeserializedHeaders());
        });
    }

    public Mono<Void> deleteModel(String modelId) {
        return this.deleteModelWithResponse(modelId).flatMap(voidResponse -> Mono.empty());
    }

    public Mono<Response<Void>> deleteModelWithResponse(String modelId) {
        return FluxUtil.withContext(context -> this.deleteModelWithResponse(modelId, (Context)context));
    }

    Mono<Response<Void>> deleteModelWithResponse(String modelId, Context context) {
        return this.protocolLayer.getDigitalTwinModels().deleteWithResponseAsync(modelId, null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE));
    }

    public Mono<Void> decommissionModel(String modelId) {
        return this.decommissionModelWithResponse(modelId).flatMap(voidResponse -> Mono.empty());
    }

    public Mono<Response<Void>> decommissionModelWithResponse(String modelId) {
        return FluxUtil.withContext(context -> this.decommissionModelWithResponse(modelId, (Context)context));
    }

    Mono<Response<Void>> decommissionModelWithResponse(String modelId, Context context) {
        JsonPatchDocument updateOperation = new JsonPatchDocument().appendReplace("/decommissioned", (Object)true);
        return this.protocolLayer.getDigitalTwinModels().updateWithResponseAsync(modelId, updateOperation, null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE));
    }

    public <T> Mono<T> getComponent(String digitalTwinId, String componentName, Class<T> clazz) {
        return this.getComponentWithResponse(digitalTwinId, componentName, clazz).map(DigitalTwinsResponse::getValue);
    }

    public <T> Mono<DigitalTwinsResponse<T>> getComponentWithResponse(String digitalTwinId, String componentName, Class<T> clazz) {
        return FluxUtil.withContext(context -> this.getComponentWithResponse(digitalTwinId, componentName, clazz, (Context)context));
    }

    <T> Mono<DigitalTwinsResponse<T>> getComponentWithResponse(String digitalTwinId, String componentName, Class<T> clazz, Context context) {
        return this.protocolLayer.getDigitalTwins().getComponentWithResponseAsync(digitalTwinId, componentName, null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).flatMap(response -> {
            Object genericResponse;
            try {
                genericResponse = DeserializationHelpers.deserializeObject(this.mapper, response.getValue(), clazz, this.serializer);
            }
            catch (JsonProcessingException e) {
                logger.error("JsonProcessingException occurred while deserializing the get component response: ", new Object[]{e});
                return Mono.error((Throwable)e);
            }
            DigitalTwinsResponseHeaders twinHeaders = (DigitalTwinsResponseHeaders)this.mapper.convertValue(response.getDeserializedHeaders(), DigitalTwinsResponseHeaders.class);
            return Mono.just(new DigitalTwinsResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), genericResponse, twinHeaders));
        });
    }

    public Mono<Void> updateComponent(String digitalTwinId, String componentName, JsonPatchDocument jsonPatch) {
        return this.updateComponentWithResponse(digitalTwinId, componentName, jsonPatch, null).flatMap(voidResponse -> Mono.empty());
    }

    public Mono<DigitalTwinsResponse<Void>> updateComponentWithResponse(String digitalTwinId, String componentName, JsonPatchDocument jsonPatch, UpdateComponentOptions options) {
        return FluxUtil.withContext(context -> this.updateComponentWithResponse(digitalTwinId, componentName, jsonPatch, options, (Context)context));
    }

    Mono<DigitalTwinsResponse<Void>> updateComponentWithResponse(String digitalTwinId, String componentName, JsonPatchDocument jsonPatch, UpdateComponentOptions options, Context context) {
        return this.protocolLayer.getDigitalTwins().updateComponentWithResponseAsync(digitalTwinId, componentName, jsonPatch, OptionsConverter.toProtocolLayerOptions(options), context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).flatMap(response -> {
            DigitalTwinsResponseHeaders twinHeaders = (DigitalTwinsResponseHeaders)this.mapper.convertValue(response.getDeserializedHeaders(), DigitalTwinsResponseHeaders.class);
            return Mono.just(new DigitalTwinsResponse<Object>(response.getRequest(), response.getStatusCode(), response.getHeaders(), null, twinHeaders));
        });
    }

    public <T> PagedFlux<T> query(String query, Class<T> clazz) {
        return this.query(query, clazz, null);
    }

    public <T> PagedFlux<T> query(String query, Class<T> clazz, QueryOptions options) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.queryFirstPage(query, clazz, options, (Context)context)), nextLink -> FluxUtil.withContext(context -> this.queryNextPage((String)nextLink, clazz, options, (Context)context)));
    }

    <T> PagedFlux<T> query(String query, Class<T> clazz, QueryOptions options, Context context) {
        return new PagedFlux(() -> this.queryFirstPage(query, clazz, options, context), nextLink -> this.queryNextPage((String)nextLink, clazz, options, context));
    }

    <T> Mono<PagedResponse<T>> queryFirstPage(String query, Class<T> clazz, QueryOptions options, Context context) {
        QuerySpecification querySpecification = new QuerySpecification().setQuery(query);
        return this.protocolLayer.getQueries().queryTwinsWithResponseAsync(querySpecification, OptionsConverter.toProtocolLayerOptions(options), context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(objectPagedResponse -> new PagedResponseBase(objectPagedResponse.getRequest(), objectPagedResponse.getStatusCode(), objectPagedResponse.getHeaders(), objectPagedResponse.getValue().getValue().stream().map(object -> {
            try {
                return DeserializationHelpers.deserializeObject(this.mapper, object, clazz, this.serializer);
            }
            catch (JsonProcessingException e) {
                logger.error("JsonProcessingException occurred while deserializing the query response: ", new Object[]{e});
                throw new RuntimeException("JsonProcessingException occurred while deserializing the query response: ", e);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()), SerializationHelpers.serializeContinuationToken(objectPagedResponse.getValue().getContinuationToken()), (Object)((QueriesQueryTwinsHeaders)objectPagedResponse.getDeserializedHeaders())));
    }

    <T> Mono<PagedResponse<T>> queryNextPage(String nextLink, Class<T> clazz, QueryOptions options, Context context) {
        QuerySpecification querySpecification = new QuerySpecification().setContinuationToken(nextLink);
        return this.protocolLayer.getQueries().queryTwinsWithResponseAsync(querySpecification, OptionsConverter.toProtocolLayerOptions(options), context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(objectPagedResponse -> new PagedResponseBase(objectPagedResponse.getRequest(), objectPagedResponse.getStatusCode(), objectPagedResponse.getHeaders(), objectPagedResponse.getValue().getValue().stream().map(object -> {
            try {
                return DeserializationHelpers.deserializeObject(this.mapper, object, clazz, this.serializer);
            }
            catch (JsonProcessingException e) {
                logger.error("JsonProcessingException occurred while deserializing the query response: ", new Object[]{e});
                throw new RuntimeException("JsonProcessingException occurred while deserializing the query response: ", e);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()), SerializationHelpers.serializeContinuationToken(objectPagedResponse.getValue().getContinuationToken()), (Object)((QueriesQueryTwinsHeaders)objectPagedResponse.getDeserializedHeaders())));
    }

    public Mono<Void> createOrReplaceEventRoute(String eventRouteId, DigitalTwinsEventRoute eventRoute) {
        return this.createOrReplaceEventRouteWithResponse(eventRouteId, eventRoute).flatMap(voidResponse -> Mono.empty());
    }

    public Mono<Response<Void>> createOrReplaceEventRouteWithResponse(String eventRouteId, DigitalTwinsEventRoute eventRoute) {
        return FluxUtil.withContext(context -> this.createOrReplaceEventRouteWithResponse(eventRouteId, eventRoute, (Context)context));
    }

    Mono<Response<Void>> createOrReplaceEventRouteWithResponse(String eventRouteId, DigitalTwinsEventRoute eventRoute, Context context) {
        return this.protocolLayer.getEventRoutes().addWithResponseAsync(eventRouteId, EventRouteConverter.map(eventRoute), null, context);
    }

    public Mono<DigitalTwinsEventRoute> getEventRoute(String eventRouteId) {
        return this.getEventRouteWithResponse(eventRouteId).map(Response::getValue);
    }

    public Mono<Response<DigitalTwinsEventRoute>> getEventRouteWithResponse(String eventRouteId) {
        return FluxUtil.withContext(context -> this.getEventRouteWithResponse(eventRouteId, (Context)context));
    }

    Mono<Response<DigitalTwinsEventRoute>> getEventRouteWithResponse(String eventRouteId, Context context) {
        return this.protocolLayer.getEventRoutes().getByIdWithResponseAsync(eventRouteId, null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(eventRouteResponse -> new SimpleResponse(eventRouteResponse.getRequest(), eventRouteResponse.getStatusCode(), eventRouteResponse.getHeaders(), (Object)EventRouteConverter.map((EventRoute)eventRouteResponse.getValue())));
    }

    public Mono<Void> deleteEventRoute(String eventRouteId) {
        return this.deleteEventRouteWithResponse(eventRouteId).flatMap(voidResponse -> Mono.empty());
    }

    public Mono<Response<Void>> deleteEventRouteWithResponse(String eventRouteId) {
        return FluxUtil.withContext(context -> this.deleteEventRouteWithResponse(eventRouteId, (Context)context));
    }

    Mono<Response<Void>> deleteEventRouteWithResponse(String eventRouteId, Context context) {
        return this.protocolLayer.getEventRoutes().deleteWithResponseAsync(eventRouteId, null, context);
    }

    public PagedFlux<DigitalTwinsEventRoute> listEventRoutes() {
        return this.listEventRoutes(null);
    }

    public PagedFlux<DigitalTwinsEventRoute> listEventRoutes(ListDigitalTwinsEventRoutesOptions options) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listEventRoutesFirstPage(options, (Context)context)), nextLink -> FluxUtil.withContext(context -> this.listEventRoutesNextPage((String)nextLink, options, (Context)context)));
    }

    PagedFlux<DigitalTwinsEventRoute> listEventRoutes(ListDigitalTwinsEventRoutesOptions options, Context context) {
        return new PagedFlux(() -> this.listEventRoutesFirstPage(options, context), nextLink -> this.listEventRoutesNextPage((String)nextLink, options, context));
    }

    Mono<PagedResponse<DigitalTwinsEventRoute>> listEventRoutesFirstPage(ListDigitalTwinsEventRoutesOptions options, Context context) {
        return this.protocolLayer.getEventRoutes().listSinglePageAsync(OptionsConverter.toProtocolLayerOptions(options), context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(this.pagedEventRouteMappingFunction);
    }

    Mono<PagedResponse<DigitalTwinsEventRoute>> listEventRoutesNextPage(String nextLink, ListDigitalTwinsEventRoutesOptions options, Context context) {
        return this.protocolLayer.getEventRoutes().listNextSinglePageAsync(nextLink, OptionsConverter.toProtocolLayerOptions(options), context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE)).map(this.pagedEventRouteMappingFunction);
    }

    public Mono<Void> publishTelemetry(String digitalTwinId, String messageId, Object payload) {
        return FluxUtil.withContext(context -> this.publishTelemetryWithResponse(digitalTwinId, messageId, payload, null, (Context)context)).flatMap(voidResponse -> Mono.empty());
    }

    public Mono<Response<Void>> publishTelemetryWithResponse(String digitalTwinId, String messageId, Object payload, PublishTelemetryOptions options) {
        return FluxUtil.withContext(context -> this.publishTelemetryWithResponse(digitalTwinId, messageId, payload, options, (Context)context));
    }

    Mono<Response<Void>> publishTelemetryWithResponse(String digitalTwinId, String messageId, Object payload, PublishTelemetryOptions options, Context context) {
        if (messageId == null || messageId.isEmpty()) {
            messageId = UUID.randomUUID().toString();
        }
        if (options == null) {
            options = new PublishTelemetryOptions();
        }
        return this.protocolLayer.getDigitalTwins().sendTelemetryWithResponseAsync(digitalTwinId, messageId, payload, options.getTimestamp().toString(), null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE));
    }

    public Mono<Void> publishComponentTelemetry(String digitalTwinId, String componentName, String messageId, Object payload) {
        return FluxUtil.withContext(context -> this.publishComponentTelemetryWithResponse(digitalTwinId, componentName, messageId, payload, null, (Context)context)).flatMap(voidResponse -> Mono.empty());
    }

    public Mono<Response<Void>> publishComponentTelemetryWithResponse(String digitalTwinId, String componentName, String messageId, Object payload, PublishComponentTelemetryOptions options) {
        return FluxUtil.withContext(context -> this.publishComponentTelemetryWithResponse(digitalTwinId, componentName, messageId, payload, options, (Context)context));
    }

    Mono<Response<Void>> publishComponentTelemetryWithResponse(String digitalTwinId, String componentName, String messageId, Object payload, PublishComponentTelemetryOptions options, Context context) {
        if (messageId == null || messageId.isEmpty()) {
            messageId = UUID.randomUUID().toString();
        }
        if (options == null) {
            options = new PublishComponentTelemetryOptions();
        }
        return this.protocolLayer.getDigitalTwins().sendComponentTelemetryWithResponseAsync(digitalTwinId, componentName, messageId, payload, options.getTimestamp().toString(), null, context.addData((Object)"az.namespace", (Object)DIGITAL_TWINS_TRACING_NAMESPACE_VALUE));
    }
}

