/*
 * Decompiled with CFR 0.152.
 */
package com.azure.digitaltwins.core;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.models.JsonPatchDocument;
import com.azure.core.util.Context;
import com.azure.digitaltwins.core.DigitalTwinsAsyncClient;
import com.azure.digitaltwins.core.DigitalTwinsServiceVersion;
import com.azure.digitaltwins.core.models.CreateOrReplaceDigitalTwinOptions;
import com.azure.digitaltwins.core.models.CreateOrReplaceRelationshipOptions;
import com.azure.digitaltwins.core.models.DeleteDigitalTwinOptions;
import com.azure.digitaltwins.core.models.DeleteRelationshipOptions;
import com.azure.digitaltwins.core.models.DigitalTwinsEventRoute;
import com.azure.digitaltwins.core.models.DigitalTwinsModelData;
import com.azure.digitaltwins.core.models.DigitalTwinsResponse;
import com.azure.digitaltwins.core.models.IncomingRelationship;
import com.azure.digitaltwins.core.models.ListDigitalTwinsEventRoutesOptions;
import com.azure.digitaltwins.core.models.ListModelsOptions;
import com.azure.digitaltwins.core.models.PublishComponentTelemetryOptions;
import com.azure.digitaltwins.core.models.PublishTelemetryOptions;
import com.azure.digitaltwins.core.models.QueryOptions;
import com.azure.digitaltwins.core.models.UpdateComponentOptions;
import com.azure.digitaltwins.core.models.UpdateDigitalTwinOptions;
import com.azure.digitaltwins.core.models.UpdateRelationshipOptions;

public final class DigitalTwinsClient {
    private final DigitalTwinsAsyncClient digitalTwinsAsyncClient;

    DigitalTwinsClient(DigitalTwinsAsyncClient digitalTwinsAsyncClient) {
        this.digitalTwinsAsyncClient = digitalTwinsAsyncClient;
    }

    public DigitalTwinsServiceVersion getServiceVersion() {
        return this.digitalTwinsAsyncClient.getServiceVersion();
    }

    public <T> T createOrReplaceDigitalTwin(String digitalTwinId, T digitalTwin, Class<T> clazz) {
        return (T)this.createOrReplaceDigitalTwinWithResponse(digitalTwinId, digitalTwin, clazz, null, Context.NONE).getValue();
    }

    public <T> Response<T> createOrReplaceDigitalTwinWithResponse(String digitalTwinId, T digitalTwin, Class<T> clazz, CreateOrReplaceDigitalTwinOptions options, Context context) {
        return (Response)this.digitalTwinsAsyncClient.createOrReplaceDigitalTwinWithResponse(digitalTwinId, digitalTwin, clazz, options, context).block();
    }

    public <T> T getDigitalTwin(String digitalTwinId, Class<T> clazz) {
        return this.getDigitalTwinWithResponse(digitalTwinId, clazz, Context.NONE).getValue();
    }

    public <T> DigitalTwinsResponse<T> getDigitalTwinWithResponse(String digitalTwinId, Class<T> clazz, Context context) {
        return (DigitalTwinsResponse)((Object)this.digitalTwinsAsyncClient.getDigitalTwinWithResponse(digitalTwinId, clazz, context).block());
    }

    public void updateDigitalTwin(String digitalTwinId, JsonPatchDocument jsonPatch) {
        this.updateDigitalTwinWithResponse(digitalTwinId, jsonPatch, null, Context.NONE);
    }

    public DigitalTwinsResponse<Void> updateDigitalTwinWithResponse(String digitalTwinId, JsonPatchDocument jsonPatch, UpdateDigitalTwinOptions options, Context context) {
        return (DigitalTwinsResponse)((Object)this.digitalTwinsAsyncClient.updateDigitalTwinWithResponse(digitalTwinId, jsonPatch, options, context).block());
    }

    public void deleteDigitalTwin(String digitalTwinId) {
        this.deleteDigitalTwinWithResponse(digitalTwinId, null, Context.NONE);
    }

    public Response<Void> deleteDigitalTwinWithResponse(String digitalTwinId, DeleteDigitalTwinOptions options, Context context) {
        return (Response)this.digitalTwinsAsyncClient.deleteDigitalTwinWithResponse(digitalTwinId, options, context).block();
    }

    public <T> T createOrReplaceRelationship(String digitalTwinId, String relationshipId, T relationship, Class<T> clazz) {
        return this.createOrReplaceRelationshipWithResponse(digitalTwinId, relationshipId, relationship, clazz, null, Context.NONE).getValue();
    }

    public <T> DigitalTwinsResponse<T> createOrReplaceRelationshipWithResponse(String digitalTwinId, String relationshipId, T relationship, Class<T> clazz, CreateOrReplaceRelationshipOptions options, Context context) {
        return (DigitalTwinsResponse)((Object)this.digitalTwinsAsyncClient.createOrReplaceRelationshipWithResponse(digitalTwinId, relationshipId, relationship, clazz, options, context).block());
    }

    public <T> T getRelationship(String digitalTwinId, String relationshipId, Class<T> clazz) {
        return this.getRelationshipWithResponse(digitalTwinId, relationshipId, clazz, Context.NONE).getValue();
    }

    public <T> DigitalTwinsResponse<T> getRelationshipWithResponse(String digitalTwinId, String relationshipId, Class<T> clazz, Context context) {
        return (DigitalTwinsResponse)((Object)this.digitalTwinsAsyncClient.getRelationshipWithResponse(digitalTwinId, relationshipId, clazz, context).block());
    }

    public void updateRelationship(String digitalTwinId, String relationshipId, JsonPatchDocument jsonPatch) {
        this.updateRelationshipWithResponse(digitalTwinId, relationshipId, jsonPatch, null, Context.NONE);
    }

    public DigitalTwinsResponse<Void> updateRelationshipWithResponse(String digitalTwinId, String relationshipId, JsonPatchDocument jsonPatch, UpdateRelationshipOptions options, Context context) {
        return (DigitalTwinsResponse)((Object)this.digitalTwinsAsyncClient.updateRelationshipWithResponse(digitalTwinId, relationshipId, jsonPatch, options, context).block());
    }

    public void deleteRelationship(String digitalTwinId, String relationshipId) {
        this.deleteRelationshipWithResponse(digitalTwinId, relationshipId, null, Context.NONE);
    }

    public Response<Void> deleteRelationshipWithResponse(String digitalTwinId, String relationshipId, DeleteRelationshipOptions options, Context context) {
        return (Response)this.digitalTwinsAsyncClient.deleteRelationshipWithResponse(digitalTwinId, relationshipId, options, context).block();
    }

    public <T> PagedIterable<T> listRelationships(String digitalTwinId, Class<T> clazz) {
        return this.listRelationships(digitalTwinId, null, clazz, Context.NONE);
    }

    public <T> PagedIterable<T> listRelationships(String digitalTwinId, String relationshipName, Class<T> clazz, Context context) {
        return new PagedIterable(this.digitalTwinsAsyncClient.listRelationships(digitalTwinId, relationshipName, clazz, context));
    }

    public PagedIterable<IncomingRelationship> listIncomingRelationships(String digitalTwinId) {
        return this.listIncomingRelationships(digitalTwinId, Context.NONE);
    }

    public PagedIterable<IncomingRelationship> listIncomingRelationships(String digitalTwinId, Context context) {
        return new PagedIterable(this.digitalTwinsAsyncClient.listIncomingRelationships(digitalTwinId, context));
    }

    public Iterable<DigitalTwinsModelData> createModels(Iterable<String> dtdlModels) {
        return (Iterable)this.createModelsWithResponse(dtdlModels, Context.NONE).getValue();
    }

    public Response<Iterable<DigitalTwinsModelData>> createModelsWithResponse(Iterable<String> dtdlModels, Context context) {
        return (Response)this.digitalTwinsAsyncClient.createModelsWithResponse(dtdlModels, context).block();
    }

    public DigitalTwinsModelData getModel(String modelId) {
        return (DigitalTwinsModelData)this.getModelWithResponse(modelId, Context.NONE).getValue();
    }

    public Response<DigitalTwinsModelData> getModelWithResponse(String modelId, Context context) {
        return (Response)this.digitalTwinsAsyncClient.getModelWithResponse(modelId, context).block();
    }

    public PagedIterable<DigitalTwinsModelData> listModels() {
        return new PagedIterable(this.digitalTwinsAsyncClient.listModels());
    }

    public PagedIterable<DigitalTwinsModelData> listModels(ListModelsOptions options, Context context) {
        return new PagedIterable(this.digitalTwinsAsyncClient.listModels(options, context));
    }

    public void deleteModel(String modelId) {
        this.deleteModelWithResponse(modelId, Context.NONE);
    }

    public Response<Void> deleteModelWithResponse(String modelId, Context context) {
        return (Response)this.digitalTwinsAsyncClient.deleteModelWithResponse(modelId, context).block();
    }

    public void decommissionModel(String modelId) {
        this.decommissionModelWithResponse(modelId, Context.NONE);
    }

    public Response<Void> decommissionModelWithResponse(String modelId, Context context) {
        return (Response)this.digitalTwinsAsyncClient.decommissionModelWithResponse(modelId, context).block();
    }

    public <T> T getComponent(String digitalTwinId, String componentName, Class<T> clazz) {
        return this.getComponentWithResponse(digitalTwinId, componentName, clazz, Context.NONE).getValue();
    }

    public <T> DigitalTwinsResponse<T> getComponentWithResponse(String digitalTwinId, String componentName, Class<T> clazz, Context context) {
        return (DigitalTwinsResponse)((Object)this.digitalTwinsAsyncClient.getComponentWithResponse(digitalTwinId, componentName, clazz, context).block());
    }

    public void updateComponent(String digitalTwinId, String componentName, JsonPatchDocument jsonPatch) {
        this.updateComponentWithResponse(digitalTwinId, componentName, jsonPatch, null, Context.NONE);
    }

    public DigitalTwinsResponse<Void> updateComponentWithResponse(String digitalTwinId, String componentName, JsonPatchDocument jsonPatch, UpdateComponentOptions options, Context context) {
        return (DigitalTwinsResponse)((Object)this.digitalTwinsAsyncClient.updateComponentWithResponse(digitalTwinId, componentName, jsonPatch, options, context).block());
    }

    public <T> PagedIterable<T> query(String query, Class<T> clazz) {
        return this.query(query, clazz, null, Context.NONE);
    }

    public <T> PagedIterable<T> query(String query, Class<T> clazz, QueryOptions options, Context context) {
        return new PagedIterable(this.digitalTwinsAsyncClient.query(query, clazz, options, context));
    }

    public void createOrReplaceEventRoute(String eventRouteId, DigitalTwinsEventRoute eventRoute) {
        this.createOrReplaceEventRouteWithResponse(eventRouteId, eventRoute, Context.NONE);
    }

    public Response<Void> createOrReplaceEventRouteWithResponse(String eventRouteId, DigitalTwinsEventRoute eventRoute, Context context) {
        return (Response)this.digitalTwinsAsyncClient.createOrReplaceEventRouteWithResponse(eventRouteId, eventRoute, context).block();
    }

    public DigitalTwinsEventRoute getEventRoute(String eventRouteId) {
        return (DigitalTwinsEventRoute)this.getEventRouteWithResponse(eventRouteId, Context.NONE).getValue();
    }

    public Response<DigitalTwinsEventRoute> getEventRouteWithResponse(String eventRouteId, Context context) {
        return (Response)this.digitalTwinsAsyncClient.getEventRouteWithResponse(eventRouteId, context).block();
    }

    public void deleteEventRoute(String eventRouteId) {
        this.deleteEventRouteWithResponse(eventRouteId, Context.NONE);
    }

    public Response<Void> deleteEventRouteWithResponse(String eventRouteId, Context context) {
        return (Response)this.digitalTwinsAsyncClient.deleteEventRouteWithResponse(eventRouteId, context).block();
    }

    public PagedIterable<DigitalTwinsEventRoute> listEventRoutes() {
        return this.listEventRoutes(null, Context.NONE);
    }

    public PagedIterable<DigitalTwinsEventRoute> listEventRoutes(ListDigitalTwinsEventRoutesOptions options, Context context) {
        return new PagedIterable(this.digitalTwinsAsyncClient.listEventRoutes(options, context));
    }

    public void publishTelemetry(String digitalTwinId, String messageId, Object payload) {
        this.publishTelemetryWithResponse(digitalTwinId, messageId, payload, null, Context.NONE);
    }

    public Response<Void> publishTelemetryWithResponse(String digitalTwinId, String messageId, Object payload, PublishTelemetryOptions options, Context context) {
        return (Response)this.digitalTwinsAsyncClient.publishTelemetryWithResponse(digitalTwinId, messageId, payload, options, context).block();
    }

    public void publishComponentTelemetry(String digitalTwinId, String componentName, String messageId, Object payload) {
        this.publishComponentTelemetryWithResponse(digitalTwinId, componentName, messageId, payload, null, Context.NONE);
    }

    public Response<Void> publishComponentTelemetryWithResponse(String digitalTwinId, String componentName, String messageId, Object payload, PublishComponentTelemetryOptions options, Context context) {
        return (Response)this.digitalTwinsAsyncClient.publishComponentTelemetryWithResponse(digitalTwinId, componentName, messageId, payload, options, context).block();
    }
}

