/*
 * Decompiled with CFR 0.152.
 */
package com.azure.digitaltwins.core;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.digitaltwins.core.DigitalTwinsAsyncClient;
import com.azure.digitaltwins.core.DigitalTwinsClient;
import com.azure.digitaltwins.core.DigitalTwinsServiceVersion;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={DigitalTwinsClient.class, DigitalTwinsAsyncClient.class})
public final class DigitalTwinsClientBuilder {
    private static final String[] ADT_PUBLIC_SCOPE = new String[]{"https://digitaltwins.azure.net/.default"};
    private static final String DIGITAL_TWINS_PROPERTIES = "azure-digital-twins.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final List<HttpPipelinePolicy> additionalPolicies = new ArrayList<HttpPipelinePolicy>();
    private String endpoint;
    private TokenCredential tokenCredential;
    private DigitalTwinsServiceVersion serviceVersion;
    private ClientOptions clientOptions;
    private HttpPipeline httpPipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private RetryPolicy retryPolicy;
    private JsonSerializer jsonSerializer;
    private static final String retryAfterHeader = null;
    private static final ChronoUnit retryAfterTimeUnit = null;
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new RetryPolicy(retryAfterHeader, retryAfterTimeUnit);
    private final Map<String, String> properties = CoreUtils.getProperties((String)"azure-digital-twins.properties");
    private Configuration configuration;

    public DigitalTwinsClientBuilder() {
        this.httpLogOptions = new HttpLogOptions();
    }

    private static HttpPipeline buildPipeline(TokenCredential tokenCredential, String endpoint, HttpLogOptions httpLogOptions, ClientOptions clientOptions, HttpClient httpClient, List<HttpPipelinePolicy> additionalPolicies, RetryPolicy retryPolicy, Configuration configuration, Map<String, String> properties) {
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = clientOptions == null ? httpLogOptions.getApplicationId() : clientOptions.getApplicationId();
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, configuration));
        policies.add(new RequestIdPolicy());
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(retryPolicy);
        policies.add(new AddDatePolicy());
        BearerTokenAuthenticationPolicy credentialPolicy = new BearerTokenAuthenticationPolicy(tokenCredential, ADT_PUBLIC_SCOPE);
        policies.add(credentialPolicy);
        policies.addAll(additionalPolicies);
        if (clientOptions != null) {
            ArrayList httpHeaderList = new ArrayList();
            clientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
            policies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        }
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).build();
    }

    public DigitalTwinsClient buildClient() {
        return new DigitalTwinsClient(this.buildAsyncClient());
    }

    public DigitalTwinsAsyncClient buildAsyncClient() {
        RetryPolicy retryPolicy;
        DigitalTwinsServiceVersion serviceVersion;
        Objects.requireNonNull(this.tokenCredential, "'tokenCredential' cannot be null.");
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null");
        Configuration buildConfiguration = this.configuration;
        if (buildConfiguration == null) {
            buildConfiguration = Configuration.getGlobalConfiguration().clone();
        }
        if ((serviceVersion = this.serviceVersion) == null) {
            serviceVersion = DigitalTwinsServiceVersion.getLatest();
        }
        if ((retryPolicy = this.retryPolicy) == null) {
            retryPolicy = DEFAULT_RETRY_POLICY;
        }
        if (this.httpPipeline == null) {
            this.httpPipeline = DigitalTwinsClientBuilder.buildPipeline(this.tokenCredential, this.endpoint, this.httpLogOptions, this.clientOptions, this.httpClient, this.additionalPolicies, retryPolicy, buildConfiguration, this.properties);
        }
        return new DigitalTwinsAsyncClient(this.endpoint, this.httpPipeline, serviceVersion, this.jsonSerializer);
    }

    public DigitalTwinsClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public DigitalTwinsClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
        return this;
    }

    public DigitalTwinsClientBuilder serviceVersion(DigitalTwinsServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public DigitalTwinsClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public DigitalTwinsClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public DigitalTwinsClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        this.additionalPolicies.add(Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null"));
        return this;
    }

    public DigitalTwinsClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public DigitalTwinsClientBuilder pipeline(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        return this;
    }

    public DigitalTwinsClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public DigitalTwinsClientBuilder serializer(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
        return this;
    }

    public DigitalTwinsClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }
}

