/*
 * Decompiled with CFR 0.152.
 */
package com.azure.digitaltwins.core.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.digitaltwins.core.implementation.DigitalTwinModelsImpl;
import com.azure.digitaltwins.core.implementation.DigitalTwinsImpl;
import com.azure.digitaltwins.core.implementation.EventRoutesImpl;
import com.azure.digitaltwins.core.implementation.QueriesImpl;

public final class AzureDigitalTwinsAPIImpl {
    private final String host;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final DigitalTwinModelsImpl digitalTwinModels;
    private final QueriesImpl queries;
    private final DigitalTwinsImpl digitalTwins;
    private final EventRoutesImpl eventRoutes;

    public String getHost() {
        return this.host;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public DigitalTwinModelsImpl getDigitalTwinModels() {
        return this.digitalTwinModels;
    }

    public QueriesImpl getQueries() {
        return this.queries;
    }

    public DigitalTwinsImpl getDigitalTwins() {
        return this.digitalTwins;
    }

    public EventRoutesImpl getEventRoutes() {
        return this.eventRoutes;
    }

    AzureDigitalTwinsAPIImpl(String host) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), host);
    }

    AzureDigitalTwinsAPIImpl(HttpPipeline httpPipeline, String host) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), host);
    }

    AzureDigitalTwinsAPIImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String host) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.host = host;
        this.apiVersion = "2020-10-31";
        this.digitalTwinModels = new DigitalTwinModelsImpl(this);
        this.queries = new QueriesImpl(this);
        this.digitalTwins = new DigitalTwinsImpl(this);
        this.eventRoutes = new EventRoutesImpl(this);
    }
}

