/*
 * Decompiled with CFR 0.152.
 */
package com.azure.digitaltwins.core.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.models.JsonPatchDocument;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.digitaltwins.core.implementation.AzureDigitalTwinsAPIImpl;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinModelsAddOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinModelsDeleteOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinModelsGetByIdOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinModelsListOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinModelsUpdateOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsModelData;
import com.azure.digitaltwins.core.implementation.models.ErrorResponseException;
import com.azure.digitaltwins.core.implementation.models.PagedDigitalTwinsModelDataCollection;
import java.util.List;
import reactor.core.publisher.Mono;

public final class DigitalTwinModelsImpl {
    private final DigitalTwinModelsService service;
    private final AzureDigitalTwinsAPIImpl client;

    DigitalTwinModelsImpl(AzureDigitalTwinsAPIImpl client) {
        this.service = (DigitalTwinModelsService)RestProxy.create(DigitalTwinModelsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<Response<List<DigitalTwinsModelData>>> addWithResponseAsync(List<Object> models, DigitalTwinModelsAddOptions digitalTwinModelsAddOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (digitalTwinModelsAddOptions != null) {
            digitalTwinModelsAddOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinModelsAddOptions != null) {
            traceparentInternal = digitalTwinModelsAddOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinModelsAddOptions != null) {
            tracestateInternal = digitalTwinModelsAddOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.add(this.client.getHost(), traceparent, tracestate, this.client.getApiVersion(), models, context);
    }

    public Mono<PagedResponse<DigitalTwinsModelData>> listSinglePageAsync(List<String> dependenciesFor, Boolean includeModelDefinition, DigitalTwinModelsListOptions digitalTwinModelsListOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (digitalTwinModelsListOptions != null) {
            digitalTwinModelsListOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinModelsListOptions != null) {
            traceparentInternal = digitalTwinModelsListOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinModelsListOptions != null) {
            tracestateInternal = digitalTwinModelsListOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        Integer maxItemsPerPageInternal = null;
        if (digitalTwinModelsListOptions != null) {
            maxItemsPerPageInternal = digitalTwinModelsListOptions.getMaxItemsPerPage();
        }
        Integer maxItemsPerPage = maxItemsPerPageInternal;
        String dependenciesForConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(dependenciesFor, CollectionFormat.CSV);
        return this.service.list(this.client.getHost(), traceparent, tracestate, dependenciesForConverted, includeModelDefinition, maxItemsPerPage, this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PagedDigitalTwinsModelDataCollection)res.getValue()).getValue(), ((PagedDigitalTwinsModelDataCollection)res.getValue()).getNextLink(), null));
    }

    public Mono<Response<DigitalTwinsModelData>> getByIdWithResponseAsync(String id, Boolean includeModelDefinition, DigitalTwinModelsGetByIdOptions digitalTwinModelsGetByIdOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (digitalTwinModelsGetByIdOptions != null) {
            digitalTwinModelsGetByIdOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinModelsGetByIdOptions != null) {
            traceparentInternal = digitalTwinModelsGetByIdOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinModelsGetByIdOptions != null) {
            tracestateInternal = digitalTwinModelsGetByIdOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.getById(this.client.getHost(), traceparent, tracestate, id, includeModelDefinition, this.client.getApiVersion(), context);
    }

    public Mono<Response<Void>> updateWithResponseAsync(String id, JsonPatchDocument updateModel, DigitalTwinModelsUpdateOptions digitalTwinModelsUpdateOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (updateModel == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateModel is required and cannot be null."));
        }
        if (digitalTwinModelsUpdateOptions != null) {
            digitalTwinModelsUpdateOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinModelsUpdateOptions != null) {
            traceparentInternal = digitalTwinModelsUpdateOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinModelsUpdateOptions != null) {
            tracestateInternal = digitalTwinModelsUpdateOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.update(this.client.getHost(), traceparent, tracestate, id, this.client.getApiVersion(), updateModel, context);
    }

    public Mono<Response<Void>> deleteWithResponseAsync(String id, DigitalTwinModelsDeleteOptions digitalTwinModelsDeleteOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (digitalTwinModelsDeleteOptions != null) {
            digitalTwinModelsDeleteOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinModelsDeleteOptions != null) {
            traceparentInternal = digitalTwinModelsDeleteOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinModelsDeleteOptions != null) {
            tracestateInternal = digitalTwinModelsDeleteOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.delete(this.client.getHost(), traceparent, tracestate, id, this.client.getApiVersion(), context);
    }

    public Mono<PagedResponse<DigitalTwinsModelData>> listNextSinglePageAsync(String nextLink, DigitalTwinModelsListOptions digitalTwinModelsListOptions, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (digitalTwinModelsListOptions != null) {
            digitalTwinModelsListOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinModelsListOptions != null) {
            traceparentInternal = digitalTwinModelsListOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinModelsListOptions != null) {
            tracestateInternal = digitalTwinModelsListOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        Integer maxItemsPerPageInternal = null;
        if (digitalTwinModelsListOptions != null) {
            maxItemsPerPageInternal = digitalTwinModelsListOptions.getMaxItemsPerPage();
        }
        Integer maxItemsPerPage = maxItemsPerPageInternal;
        return this.service.listNext(nextLink, this.client.getHost(), traceparent, tracestate, maxItemsPerPage, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PagedDigitalTwinsModelDataCollection)res.getValue()).getValue(), ((PagedDigitalTwinsModelDataCollection)res.getValue()).getNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AzureDigitalTwinsAPI")
    private static interface DigitalTwinModelsService {
        @Post(value="/models")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<List<DigitalTwinsModelData>>> add(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") List<Object> var5, Context var6);

        @Get(value="/models")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<PagedDigitalTwinsModelDataCollection>> list(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @QueryParam(value="dependenciesFor") String var4, @QueryParam(value="includeModelDefinition") Boolean var5, @HeaderParam(value="max-items-per-page") Integer var6, @QueryParam(value="api-version") String var7, Context var8);

        @Get(value="/models/{id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<DigitalTwinsModelData>> getById(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @QueryParam(value="includeModelDefinition") Boolean var5, @QueryParam(value="api-version") String var6, Context var7);

        @Patch(value="/models/{id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> update(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json-patch+json") JsonPatchDocument var6, Context var7);

        @Delete(value="/models/{id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<PagedDigitalTwinsModelDataCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="traceparent") String var3, @HeaderParam(value="tracestate") String var4, @HeaderParam(value="max-items-per-page") Integer var5, Context var6);
    }
}

