/*
 * Decompiled with CFR 0.152.
 */
package com.azure.digitaltwins.core.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.models.JsonPatchDocument;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.digitaltwins.core.implementation.AzureDigitalTwinsAPIImpl;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsAddOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsAddRelationshipOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsAddRelationshipResponse;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsAddResponse;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsDeleteOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsDeleteRelationshipOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsGetByIdOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsGetByIdResponse;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsGetComponentOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsGetComponentResponse;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsGetRelationshipByIdOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsGetRelationshipByIdResponse;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsListIncomingRelationshipsOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsListRelationshipsOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsSendComponentTelemetryOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsSendTelemetryOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsUpdateComponentOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsUpdateComponentResponse;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsUpdateOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsUpdateRelationshipOptions;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsUpdateRelationshipResponse;
import com.azure.digitaltwins.core.implementation.models.DigitalTwinsUpdateResponse;
import com.azure.digitaltwins.core.implementation.models.ErrorResponseException;
import com.azure.digitaltwins.core.implementation.models.IncomingRelationship;
import com.azure.digitaltwins.core.implementation.models.IncomingRelationshipCollection;
import com.azure.digitaltwins.core.implementation.models.RelationshipCollection;
import reactor.core.publisher.Mono;

public final class DigitalTwinsImpl {
    private final DigitalTwinsService service;
    private final AzureDigitalTwinsAPIImpl client;

    DigitalTwinsImpl(AzureDigitalTwinsAPIImpl client) {
        this.service = (DigitalTwinsService)RestProxy.create(DigitalTwinsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<DigitalTwinsGetByIdResponse> getByIdWithResponseAsync(String id, DigitalTwinsGetByIdOptions digitalTwinsGetByIdOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (digitalTwinsGetByIdOptions != null) {
            digitalTwinsGetByIdOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsGetByIdOptions != null) {
            traceparentInternal = digitalTwinsGetByIdOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsGetByIdOptions != null) {
            tracestateInternal = digitalTwinsGetByIdOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.getById(this.client.getHost(), traceparent, tracestate, id, this.client.getApiVersion(), context);
    }

    public Mono<DigitalTwinsAddResponse> addWithResponseAsync(String id, Object twin, DigitalTwinsAddOptions digitalTwinsAddOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (twin == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter twin is required and cannot be null."));
        }
        if (digitalTwinsAddOptions != null) {
            digitalTwinsAddOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsAddOptions != null) {
            traceparentInternal = digitalTwinsAddOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsAddOptions != null) {
            tracestateInternal = digitalTwinsAddOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        String ifNoneMatchInternal = null;
        if (digitalTwinsAddOptions != null) {
            ifNoneMatchInternal = digitalTwinsAddOptions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        return this.service.add(this.client.getHost(), traceparent, tracestate, id, ifNoneMatch, this.client.getApiVersion(), twin, context);
    }

    public Mono<Response<Void>> deleteWithResponseAsync(String id, DigitalTwinsDeleteOptions digitalTwinsDeleteOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (digitalTwinsDeleteOptions != null) {
            digitalTwinsDeleteOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsDeleteOptions != null) {
            traceparentInternal = digitalTwinsDeleteOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsDeleteOptions != null) {
            tracestateInternal = digitalTwinsDeleteOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        String ifMatchInternal = null;
        if (digitalTwinsDeleteOptions != null) {
            ifMatchInternal = digitalTwinsDeleteOptions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        return this.service.delete(this.client.getHost(), traceparent, tracestate, id, ifMatch, this.client.getApiVersion(), context);
    }

    public Mono<DigitalTwinsUpdateResponse> updateWithResponseAsync(String id, JsonPatchDocument patchDocument, DigitalTwinsUpdateOptions digitalTwinsUpdateOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (patchDocument == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter patchDocument is required and cannot be null."));
        }
        if (digitalTwinsUpdateOptions != null) {
            digitalTwinsUpdateOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsUpdateOptions != null) {
            traceparentInternal = digitalTwinsUpdateOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsUpdateOptions != null) {
            tracestateInternal = digitalTwinsUpdateOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        String ifMatchInternal = null;
        if (digitalTwinsUpdateOptions != null) {
            ifMatchInternal = digitalTwinsUpdateOptions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        return this.service.update(this.client.getHost(), traceparent, tracestate, id, ifMatch, this.client.getApiVersion(), patchDocument, context);
    }

    public Mono<DigitalTwinsGetRelationshipByIdResponse> getRelationshipByIdWithResponseAsync(String id, String relationshipId, DigitalTwinsGetRelationshipByIdOptions digitalTwinsGetRelationshipByIdOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (relationshipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relationshipId is required and cannot be null."));
        }
        if (digitalTwinsGetRelationshipByIdOptions != null) {
            digitalTwinsGetRelationshipByIdOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsGetRelationshipByIdOptions != null) {
            traceparentInternal = digitalTwinsGetRelationshipByIdOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsGetRelationshipByIdOptions != null) {
            tracestateInternal = digitalTwinsGetRelationshipByIdOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.getRelationshipById(this.client.getHost(), traceparent, tracestate, id, relationshipId, this.client.getApiVersion(), context);
    }

    public Mono<DigitalTwinsAddRelationshipResponse> addRelationshipWithResponseAsync(String id, String relationshipId, Object relationship, DigitalTwinsAddRelationshipOptions digitalTwinsAddRelationshipOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (relationshipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relationshipId is required and cannot be null."));
        }
        if (relationship == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relationship is required and cannot be null."));
        }
        if (digitalTwinsAddRelationshipOptions != null) {
            digitalTwinsAddRelationshipOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsAddRelationshipOptions != null) {
            traceparentInternal = digitalTwinsAddRelationshipOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsAddRelationshipOptions != null) {
            tracestateInternal = digitalTwinsAddRelationshipOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        String ifNoneMatchInternal = null;
        if (digitalTwinsAddRelationshipOptions != null) {
            ifNoneMatchInternal = digitalTwinsAddRelationshipOptions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        return this.service.addRelationship(this.client.getHost(), traceparent, tracestate, id, relationshipId, ifNoneMatch, this.client.getApiVersion(), relationship, context);
    }

    public Mono<Response<Void>> deleteRelationshipWithResponseAsync(String id, String relationshipId, DigitalTwinsDeleteRelationshipOptions digitalTwinsDeleteRelationshipOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (relationshipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relationshipId is required and cannot be null."));
        }
        if (digitalTwinsDeleteRelationshipOptions != null) {
            digitalTwinsDeleteRelationshipOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsDeleteRelationshipOptions != null) {
            traceparentInternal = digitalTwinsDeleteRelationshipOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsDeleteRelationshipOptions != null) {
            tracestateInternal = digitalTwinsDeleteRelationshipOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        String ifMatchInternal = null;
        if (digitalTwinsDeleteRelationshipOptions != null) {
            ifMatchInternal = digitalTwinsDeleteRelationshipOptions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        return this.service.deleteRelationship(this.client.getHost(), traceparent, tracestate, id, relationshipId, ifMatch, this.client.getApiVersion(), context);
    }

    public Mono<DigitalTwinsUpdateRelationshipResponse> updateRelationshipWithResponseAsync(String id, String relationshipId, JsonPatchDocument patchDocument, DigitalTwinsUpdateRelationshipOptions digitalTwinsUpdateRelationshipOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (relationshipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relationshipId is required and cannot be null."));
        }
        if (patchDocument == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter patchDocument is required and cannot be null."));
        }
        if (digitalTwinsUpdateRelationshipOptions != null) {
            digitalTwinsUpdateRelationshipOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsUpdateRelationshipOptions != null) {
            traceparentInternal = digitalTwinsUpdateRelationshipOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsUpdateRelationshipOptions != null) {
            tracestateInternal = digitalTwinsUpdateRelationshipOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        String ifMatchInternal = null;
        if (digitalTwinsUpdateRelationshipOptions != null) {
            ifMatchInternal = digitalTwinsUpdateRelationshipOptions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        return this.service.updateRelationship(this.client.getHost(), traceparent, tracestate, id, relationshipId, ifMatch, this.client.getApiVersion(), patchDocument, context);
    }

    public Mono<PagedResponse<Object>> listRelationshipsSinglePageAsync(String id, String relationshipName, DigitalTwinsListRelationshipsOptions digitalTwinsListRelationshipsOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (digitalTwinsListRelationshipsOptions != null) {
            digitalTwinsListRelationshipsOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsListRelationshipsOptions != null) {
            traceparentInternal = digitalTwinsListRelationshipsOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsListRelationshipsOptions != null) {
            tracestateInternal = digitalTwinsListRelationshipsOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.listRelationships(this.client.getHost(), traceparent, tracestate, id, relationshipName, this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RelationshipCollection)res.getValue()).getValue(), ((RelationshipCollection)res.getValue()).getNextLink(), null));
    }

    public Mono<PagedResponse<IncomingRelationship>> listIncomingRelationshipsSinglePageAsync(String id, DigitalTwinsListIncomingRelationshipsOptions digitalTwinsListIncomingRelationshipsOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (digitalTwinsListIncomingRelationshipsOptions != null) {
            digitalTwinsListIncomingRelationshipsOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsListIncomingRelationshipsOptions != null) {
            traceparentInternal = digitalTwinsListIncomingRelationshipsOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsListIncomingRelationshipsOptions != null) {
            tracestateInternal = digitalTwinsListIncomingRelationshipsOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.listIncomingRelationships(this.client.getHost(), traceparent, tracestate, id, this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncomingRelationshipCollection)res.getValue()).getValue(), ((IncomingRelationshipCollection)res.getValue()).getNextLink(), null));
    }

    public Mono<Response<Void>> sendTelemetryWithResponseAsync(String id, String messageId, Object telemetry, String telemetrySourceTime, DigitalTwinsSendTelemetryOptions digitalTwinsSendTelemetryOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (messageId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter messageId is required and cannot be null."));
        }
        if (telemetry == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter telemetry is required and cannot be null."));
        }
        if (digitalTwinsSendTelemetryOptions != null) {
            digitalTwinsSendTelemetryOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsSendTelemetryOptions != null) {
            traceparentInternal = digitalTwinsSendTelemetryOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsSendTelemetryOptions != null) {
            tracestateInternal = digitalTwinsSendTelemetryOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.sendTelemetry(this.client.getHost(), traceparent, tracestate, id, messageId, telemetrySourceTime, this.client.getApiVersion(), telemetry, context);
    }

    public Mono<Response<Void>> sendComponentTelemetryWithResponseAsync(String id, String componentPath, String messageId, Object telemetry, String telemetrySourceTime, DigitalTwinsSendComponentTelemetryOptions digitalTwinsSendComponentTelemetryOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (componentPath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPath is required and cannot be null."));
        }
        if (messageId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter messageId is required and cannot be null."));
        }
        if (telemetry == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter telemetry is required and cannot be null."));
        }
        if (digitalTwinsSendComponentTelemetryOptions != null) {
            digitalTwinsSendComponentTelemetryOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsSendComponentTelemetryOptions != null) {
            traceparentInternal = digitalTwinsSendComponentTelemetryOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsSendComponentTelemetryOptions != null) {
            tracestateInternal = digitalTwinsSendComponentTelemetryOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.sendComponentTelemetry(this.client.getHost(), traceparent, tracestate, id, componentPath, messageId, telemetrySourceTime, this.client.getApiVersion(), telemetry, context);
    }

    public Mono<DigitalTwinsGetComponentResponse> getComponentWithResponseAsync(String id, String componentPath, DigitalTwinsGetComponentOptions digitalTwinsGetComponentOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (componentPath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPath is required and cannot be null."));
        }
        if (digitalTwinsGetComponentOptions != null) {
            digitalTwinsGetComponentOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsGetComponentOptions != null) {
            traceparentInternal = digitalTwinsGetComponentOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsGetComponentOptions != null) {
            tracestateInternal = digitalTwinsGetComponentOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.getComponent(this.client.getHost(), traceparent, tracestate, id, componentPath, this.client.getApiVersion(), context);
    }

    public Mono<DigitalTwinsUpdateComponentResponse> updateComponentWithResponseAsync(String id, String componentPath, JsonPatchDocument patchDocument, DigitalTwinsUpdateComponentOptions digitalTwinsUpdateComponentOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (componentPath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter componentPath is required and cannot be null."));
        }
        if (patchDocument == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter patchDocument is required and cannot be null."));
        }
        if (digitalTwinsUpdateComponentOptions != null) {
            digitalTwinsUpdateComponentOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsUpdateComponentOptions != null) {
            traceparentInternal = digitalTwinsUpdateComponentOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsUpdateComponentOptions != null) {
            tracestateInternal = digitalTwinsUpdateComponentOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        String ifMatchInternal = null;
        if (digitalTwinsUpdateComponentOptions != null) {
            ifMatchInternal = digitalTwinsUpdateComponentOptions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        return this.service.updateComponent(this.client.getHost(), traceparent, tracestate, id, componentPath, ifMatch, this.client.getApiVersion(), patchDocument, context);
    }

    public Mono<PagedResponse<Object>> listRelationshipsNextSinglePageAsync(String nextLink, DigitalTwinsListRelationshipsOptions digitalTwinsListRelationshipsOptions, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (digitalTwinsListRelationshipsOptions != null) {
            digitalTwinsListRelationshipsOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsListRelationshipsOptions != null) {
            traceparentInternal = digitalTwinsListRelationshipsOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsListRelationshipsOptions != null) {
            tracestateInternal = digitalTwinsListRelationshipsOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.listRelationshipsNext(nextLink, this.client.getHost(), traceparent, tracestate, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RelationshipCollection)res.getValue()).getValue(), ((RelationshipCollection)res.getValue()).getNextLink(), null));
    }

    public Mono<PagedResponse<IncomingRelationship>> listIncomingRelationshipsNextSinglePageAsync(String nextLink, DigitalTwinsListIncomingRelationshipsOptions digitalTwinsListIncomingRelationshipsOptions, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (digitalTwinsListIncomingRelationshipsOptions != null) {
            digitalTwinsListIncomingRelationshipsOptions.validate();
        }
        String traceparentInternal = null;
        if (digitalTwinsListIncomingRelationshipsOptions != null) {
            traceparentInternal = digitalTwinsListIncomingRelationshipsOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (digitalTwinsListIncomingRelationshipsOptions != null) {
            tracestateInternal = digitalTwinsListIncomingRelationshipsOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.listIncomingRelationshipsNext(nextLink, this.client.getHost(), traceparent, tracestate, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncomingRelationshipCollection)res.getValue()).getValue(), ((IncomingRelationshipCollection)res.getValue()).getNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AzureDigitalTwinsAPI")
    private static interface DigitalTwinsService {
        @Get(value="/digitaltwins/{id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<DigitalTwinsGetByIdResponse> getById(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Put(value="/digitaltwins/{id}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<DigitalTwinsAddResponse> add(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") Object var7, Context var8);

        @Delete(value="/digitaltwins/{id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @HeaderParam(value="If-Match") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Patch(value="/digitaltwins/{id}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<DigitalTwinsUpdateResponse> update(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @HeaderParam(value="If-Match") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json-patch+json") JsonPatchDocument var7, Context var8);

        @Get(value="/digitaltwins/{id}/relationships/{relationshipId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<DigitalTwinsGetRelationshipByIdResponse> getRelationshipById(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @PathParam(value="relationshipId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Put(value="/digitaltwins/{id}/relationships/{relationshipId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<DigitalTwinsAddRelationshipResponse> addRelationship(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @PathParam(value="relationshipId") String var5, @HeaderParam(value="If-None-Match") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") Object var8, Context var9);

        @Delete(value="/digitaltwins/{id}/relationships/{relationshipId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> deleteRelationship(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @PathParam(value="relationshipId") String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Patch(value="/digitaltwins/{id}/relationships/{relationshipId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<DigitalTwinsUpdateRelationshipResponse> updateRelationship(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @PathParam(value="relationshipId") String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json-patch+json") JsonPatchDocument var8, Context var9);

        @Get(value="/digitaltwins/{id}/relationships")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<RelationshipCollection>> listRelationships(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @QueryParam(value="relationshipName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Get(value="/digitaltwins/{id}/incomingrelationships")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<IncomingRelationshipCollection>> listIncomingRelationships(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Post(value="/digitaltwins/{id}/telemetry")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> sendTelemetry(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @HeaderParam(value="Message-Id") String var5, @HeaderParam(value="Telemetry-Source-Time") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") Object var8, Context var9);

        @Post(value="/digitaltwins/{id}/components/{componentPath}/telemetry")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> sendComponentTelemetry(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @PathParam(value="componentPath") String var5, @HeaderParam(value="Message-Id") String var6, @HeaderParam(value="Telemetry-Source-Time") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") Object var9, Context var10);

        @Get(value="/digitaltwins/{id}/components/{componentPath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<DigitalTwinsGetComponentResponse> getComponent(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @PathParam(value="componentPath") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Patch(value="/digitaltwins/{id}/components/{componentPath}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<DigitalTwinsUpdateComponentResponse> updateComponent(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @PathParam(value="componentPath") String var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json-patch+json") JsonPatchDocument var8, Context var9);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<RelationshipCollection>> listRelationshipsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="traceparent") String var3, @HeaderParam(value="tracestate") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<IncomingRelationshipCollection>> listIncomingRelationshipsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="traceparent") String var3, @HeaderParam(value="tracestate") String var4, Context var5);
    }
}

