/*
 * Decompiled with CFR 0.152.
 */
package com.azure.digitaltwins.core.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.digitaltwins.core.implementation.AzureDigitalTwinsAPIImpl;
import com.azure.digitaltwins.core.implementation.models.ErrorResponseException;
import com.azure.digitaltwins.core.implementation.models.EventRoute;
import com.azure.digitaltwins.core.implementation.models.EventRouteCollection;
import com.azure.digitaltwins.core.implementation.models.EventRoutesAddOptions;
import com.azure.digitaltwins.core.implementation.models.EventRoutesDeleteOptions;
import com.azure.digitaltwins.core.implementation.models.EventRoutesGetByIdOptions;
import com.azure.digitaltwins.core.implementation.models.EventRoutesListOptions;
import reactor.core.publisher.Mono;

public final class EventRoutesImpl {
    private final EventRoutesService service;
    private final AzureDigitalTwinsAPIImpl client;

    EventRoutesImpl(AzureDigitalTwinsAPIImpl client) {
        this.service = (EventRoutesService)RestProxy.create(EventRoutesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<PagedResponse<EventRoute>> listSinglePageAsync(EventRoutesListOptions eventRoutesListOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (eventRoutesListOptions != null) {
            eventRoutesListOptions.validate();
        }
        String traceparentInternal = null;
        if (eventRoutesListOptions != null) {
            traceparentInternal = eventRoutesListOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (eventRoutesListOptions != null) {
            tracestateInternal = eventRoutesListOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        Integer maxItemsPerPageInternal = null;
        if (eventRoutesListOptions != null) {
            maxItemsPerPageInternal = eventRoutesListOptions.getMaxItemsPerPage();
        }
        Integer maxItemsPerPage = maxItemsPerPageInternal;
        return this.service.list(this.client.getHost(), traceparent, tracestate, maxItemsPerPage, this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventRouteCollection)res.getValue()).getValue(), ((EventRouteCollection)res.getValue()).getNextLink(), null));
    }

    public Mono<Response<EventRoute>> getByIdWithResponseAsync(String id, EventRoutesGetByIdOptions eventRoutesGetByIdOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (eventRoutesGetByIdOptions != null) {
            eventRoutesGetByIdOptions.validate();
        }
        String traceparentInternal = null;
        if (eventRoutesGetByIdOptions != null) {
            traceparentInternal = eventRoutesGetByIdOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (eventRoutesGetByIdOptions != null) {
            tracestateInternal = eventRoutesGetByIdOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.getById(this.client.getHost(), traceparent, tracestate, id, this.client.getApiVersion(), context);
    }

    public Mono<Response<Void>> addWithResponseAsync(String id, EventRoute eventRoute, EventRoutesAddOptions eventRoutesAddOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (eventRoutesAddOptions != null) {
            eventRoutesAddOptions.validate();
        }
        if (eventRoute != null) {
            eventRoute.validate();
        }
        String traceparentInternal = null;
        if (eventRoutesAddOptions != null) {
            traceparentInternal = eventRoutesAddOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (eventRoutesAddOptions != null) {
            tracestateInternal = eventRoutesAddOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.add(this.client.getHost(), traceparent, tracestate, id, this.client.getApiVersion(), eventRoute, context);
    }

    public Mono<Response<Void>> deleteWithResponseAsync(String id, EventRoutesDeleteOptions eventRoutesDeleteOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (eventRoutesDeleteOptions != null) {
            eventRoutesDeleteOptions.validate();
        }
        String traceparentInternal = null;
        if (eventRoutesDeleteOptions != null) {
            traceparentInternal = eventRoutesDeleteOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (eventRoutesDeleteOptions != null) {
            tracestateInternal = eventRoutesDeleteOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        return this.service.delete(this.client.getHost(), traceparent, tracestate, id, this.client.getApiVersion(), context);
    }

    public Mono<PagedResponse<EventRoute>> listNextSinglePageAsync(String nextLink, EventRoutesListOptions eventRoutesListOptions, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (eventRoutesListOptions != null) {
            eventRoutesListOptions.validate();
        }
        String traceparentInternal = null;
        if (eventRoutesListOptions != null) {
            traceparentInternal = eventRoutesListOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (eventRoutesListOptions != null) {
            tracestateInternal = eventRoutesListOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        Integer maxItemsPerPageInternal = null;
        if (eventRoutesListOptions != null) {
            maxItemsPerPageInternal = eventRoutesListOptions.getMaxItemsPerPage();
        }
        Integer maxItemsPerPage = maxItemsPerPageInternal;
        return this.service.listNext(nextLink, this.client.getHost(), traceparent, tracestate, maxItemsPerPage, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventRouteCollection)res.getValue()).getValue(), ((EventRouteCollection)res.getValue()).getNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AzureDigitalTwinsAPI")
    private static interface EventRoutesService {
        @Get(value="/eventroutes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<EventRouteCollection>> list(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @HeaderParam(value="max-items-per-page") Integer var4, @QueryParam(value="api-version") String var5, Context var6);

        @Get(value="/eventroutes/{id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<EventRoute>> getById(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Put(value="/eventroutes/{id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> add(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") EventRoute var6, Context var7);

        @Delete(value="/eventroutes/{id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @PathParam(value="id") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<EventRouteCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="traceparent") String var3, @HeaderParam(value="tracestate") String var4, @HeaderParam(value="max-items-per-page") Integer var5, Context var6);
    }
}

