/*
 * Decompiled with CFR 0.152.
 */
package com.azure.digitaltwins.core.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.digitaltwins.core.implementation.AzureDigitalTwinsAPIImpl;
import com.azure.digitaltwins.core.implementation.models.ErrorResponseException;
import com.azure.digitaltwins.core.implementation.models.QueriesQueryTwinsResponse;
import com.azure.digitaltwins.core.implementation.models.QuerySpecification;
import com.azure.digitaltwins.core.implementation.models.QueryTwinsOptions;
import reactor.core.publisher.Mono;

public final class QueriesImpl {
    private final QueriesService service;
    private final AzureDigitalTwinsAPIImpl client;

    QueriesImpl(AzureDigitalTwinsAPIImpl client) {
        this.service = (QueriesService)RestProxy.create(QueriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<QueriesQueryTwinsResponse> queryTwinsWithResponseAsync(QuerySpecification querySpecification, QueryTwinsOptions queryTwinsOptions, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (querySpecification == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter querySpecification is required and cannot be null."));
        }
        querySpecification.validate();
        if (queryTwinsOptions != null) {
            queryTwinsOptions.validate();
        }
        String traceparentInternal = null;
        if (queryTwinsOptions != null) {
            traceparentInternal = queryTwinsOptions.getTraceparent();
        }
        String traceparent = traceparentInternal;
        String tracestateInternal = null;
        if (queryTwinsOptions != null) {
            tracestateInternal = queryTwinsOptions.getTracestate();
        }
        String tracestate = tracestateInternal;
        Integer maxItemsPerPageInternal = null;
        if (queryTwinsOptions != null) {
            maxItemsPerPageInternal = queryTwinsOptions.getMaxItemsPerPage();
        }
        Integer maxItemsPerPage = maxItemsPerPageInternal;
        return this.service.queryTwins(this.client.getHost(), traceparent, tracestate, maxItemsPerPage, this.client.getApiVersion(), querySpecification, context);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AzureDigitalTwinsAPI")
    private static interface QueriesService {
        @Post(value="/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<QueriesQueryTwinsResponse> queryTwins(@HostParam(value="$host") String var1, @HeaderParam(value="traceparent") String var2, @HeaderParam(value="tracestate") String var3, @HeaderParam(value="max-items-per-page") Integer var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") QuerySpecification var6, Context var7);
    }
}

