/*
 * Decompiled with CFR 0.152.
 */
package com.azure.digitaltwins.core.implementation.serializer;

import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class DeserializationHelpers {
    public static <T> T deserializeObject(ObjectMapper mapper, Object payload, Class<T> clazz, JsonSerializer customJsonSerializer) throws JsonProcessingException {
        if (customJsonSerializer == null) {
            if (clazz.isAssignableFrom(String.class)) {
                return (T)mapper.writeValueAsString(payload);
            }
            return (T)mapper.convertValue(payload, clazz);
        }
        ByteArrayOutputStream sourceStream = new ByteArrayOutputStream();
        customJsonSerializer.serialize((OutputStream)sourceStream, payload);
        return (T)customJsonSerializer.deserialize((InputStream)new ByteArrayInputStream(sourceStream.toByteArray()), TypeReference.createInstance(clazz));
    }
}

