/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.broker;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.identity.AuthenticationRecord;
import com.azure.identity.BrowserCustomizationOptions;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.InteractiveBrowserCredentialBuilder;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.identity.implementation.CredentialBuilderBaseHelper;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public class InteractiveBrowserBrokerCredentialBuilder
extends InteractiveBrowserCredentialBuilder {
    public InteractiveBrowserBrokerCredentialBuilder setWindowHandle(long windowHandle) {
        CredentialBuilderBaseHelper.getClientOptions((CredentialBuilderBase)this).setBrokerWindowHandle(windowHandle);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder enableLegacyMsaPassthrough() {
        CredentialBuilderBaseHelper.getClientOptions((CredentialBuilderBase)this).setEnableLegacyMsaPassthrough(true);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder clientOptions(ClientOptions clientOptions) {
        super.clientOptions(clientOptions);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder addPolicy(HttpPipelinePolicy policy) {
        super.addPolicy(policy);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder port(int port) {
        super.port(port);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder additionallyAllowedTenants(String ... additionallyAllowedTenants) {
        super.additionallyAllowedTenants(additionallyAllowedTenants);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder authenticationRecord(AuthenticationRecord authenticationRecord) {
        super.authenticationRecord(authenticationRecord);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder browserCustomizationOptions(BrowserCustomizationOptions browserCustomizationOptions) {
        super.browserCustomizationOptions(browserCustomizationOptions);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder clientId(String clientId) {
        super.clientId(clientId);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder configuration(Configuration configuration) {
        super.configuration(configuration);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder authorityHost(String authorityHost) {
        super.authorityHost(authorityHost);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder disableAutomaticAuthentication() {
        super.disableAutomaticAuthentication();
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder disableInstanceDiscovery() {
        super.disableInstanceDiscovery();
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder enableAccountIdentifierLogging() {
        super.enableAccountIdentifierLogging();
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder enableUnsafeSupportLogging() {
        super.enableUnsafeSupportLogging();
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder executorService(ExecutorService executorService) {
        super.executorService(executorService);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder httpClient(HttpClient client) {
        super.httpClient(client);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder httpLogOptions(HttpLogOptions logOptions) {
        super.httpLogOptions(logOptions);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder loginHint(String loginHint) {
        super.loginHint(loginHint);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder pipeline(HttpPipeline pipeline) {
        super.pipeline(pipeline);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder maxRetry(int maxRetry) {
        super.maxRetry(maxRetry);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder redirectUrl(String redirectUrl) {
        super.redirectUrl(redirectUrl);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder additionallyAllowedTenants(List<String> additionallyAllowedTenants) {
        super.additionallyAllowedTenants(additionallyAllowedTenants);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder retryOptions(RetryOptions retryOptions) {
        super.retryOptions(retryOptions);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder retryPolicy(RetryPolicy retryPolicy) {
        super.retryPolicy(retryPolicy);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder tenantId(String tenantId) {
        super.tenantId(tenantId);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder retryTimeout(Function<Duration, Duration> retryTimeout) {
        super.retryTimeout(retryTimeout);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        super.tokenCachePersistenceOptions(tokenCachePersistenceOptions);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder httpPipeline(HttpPipeline httpPipeline) {
        super.httpPipeline(httpPipeline);
        return this;
    }

    public InteractiveBrowserBrokerCredentialBuilder proxyOptions(ProxyOptions proxyOptions) {
        super.proxyOptions(proxyOptions);
        return this;
    }
}

