/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.providers.jdbc.implementation.enums;

import com.azure.core.util.Configuration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public enum AuthProperty {
    CLIENT_ID("azure.clientId", "Client ID to use when performing service principal authentication with Azure.", false),
    CLIENT_SECRET("azure.clientSecret", "Client secret to use when performing service principal authentication with Azure.", false),
    CLIENT_CERTIFICATE_PATH("azure.clientCertificatePath", "Path of a PEM/PFX certificate file to use when performing service principal authentication with Azure.", false),
    CLIENT_CERTIFICATE_PASSWORD("azure.clientCertificatePassword", "Password of the certificate file.", false),
    USERNAME("azure.username", "Username to use when performing username/password authentication with Azure.", false),
    PASSWORD("azure.password", "Password to use when performing username/password authentication with Azure.", false),
    MANAGED_IDENTITY_ENABLED("azure.managedIdentityEnabled", "Whether to enable managed identity to authenticate with Azure.", false),
    AUTHORITY_HOST("azure.authorityHost", "https://login.microsoftonline.com/", "The well known authority hosts for the Azure Public Cloud and sovereign clouds.", true),
    TENANT_ID("azure.tenantId", "Tenant ID for Azure resources.", true),
    CLAIMS("azure.claims", "Claims for Azure resources.", false),
    SCOPES("azure.scopes", "Scopes for Azure resources.", false),
    GET_TOKEN_TIMEOUT("azure.accessTokenTimeoutInSeconds", "Max time to get an access token.", false),
    TOKEN_CREDENTIAL_PROVIDER_CLASS_NAME("azure.tokenCredentialProviderClassName", "The canonical class name of a class that implements 'TokenCredentialProvider'.", false),
    TOKEN_CREDENTIAL_BEAN_NAME("azure.tokenCredentialBeanName", "springCloudAzureDefaultCredential", "The given bean name of a TokenCredential bean in the Spring context.", false);

    String propertyKey;
    String defaultValue;
    String description;
    boolean required;

    private AuthProperty(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    private AuthProperty(String propertyKey, String description, boolean required) {
        this.propertyKey = propertyKey;
        this.description = description;
        this.required = required;
    }

    private AuthProperty(String propertyKey, String defaultValue, String description, boolean required) {
        this.propertyKey = propertyKey;
        this.defaultValue = defaultValue;
        this.description = description;
        this.required = required;
    }

    public String get(Properties properties) {
        return properties.getProperty(this.propertyKey, AuthPropertyConfigurationProperty.getConfigurationPropertyValue(this));
    }

    public Boolean getBoolean(Properties properties) {
        return Boolean.parseBoolean(this.get(properties));
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public Integer getInteger(Properties properties) {
        return Integer.parseInt(this.get(properties));
    }

    public void setProperty(Properties properties, String value) {
        if (value == null) {
            properties.remove(this.propertyKey);
        } else {
            properties.put(this.propertyKey, value);
        }
    }

    public void setProperty(Map<String, String> map, String value) {
        if (value == null) {
            map.remove(this.propertyKey);
        } else {
            map.put(this.propertyKey, value);
        }
    }

    static class AuthPropertyConfigurationProperty {
        private static Configuration configuration = Configuration.getGlobalConfiguration();
        static Map<AuthProperty, String> authPropertyKeyAndConfigurationPropertyKey = new HashMap<AuthProperty, String>(){
            {
                this.put(CLIENT_ID, "AZURE_CLIENT_ID");
                this.put(CLIENT_SECRET, "AZURE_CLIENT_SECRET");
                this.put(CLIENT_CERTIFICATE_PATH, "AZURE_CLIENT_CERTIFICATE_PATH");
                this.put(USERNAME, "AZURE_USERNAME");
                this.put(PASSWORD, "AZURE_PASSWORD");
                this.put(AUTHORITY_HOST, "AZURE_AUTHORITY_HOST");
                this.put(TENANT_ID, "AZURE_TENANT_ID");
            }
        };

        AuthPropertyConfigurationProperty() {
        }

        static String getConfigurationPropertyValue(AuthProperty authProperty) {
            String key = authPropertyKeyAndConfigurationPropertyKey.get((Object)authProperty);
            if (key == null) {
                return authProperty.defaultValue;
            }
            String value = configuration.get(key);
            return value == null ? authProperty.defaultValue : value;
        }
    }
}

