/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.providers.postgresql;

import com.azure.identity.providers.jdbc.implementation.enums.AuthProperty;
import com.azure.identity.providers.jdbc.implementation.template.AzureAuthenticationTemplate;
import java.util.Properties;
import org.postgresql.plugin.AuthenticationPlugin;
import org.postgresql.plugin.AuthenticationRequestType;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class AzureIdentityPostgresqlAuthenticationPlugin
implements AuthenticationPlugin {
    private static final String OSSRDBMS_SCOPE = "https://ossrdbms-aad.database.windows.net/.default";
    private final AzureAuthenticationTemplate azureAuthenticationTemplate;

    public AzureIdentityPostgresqlAuthenticationPlugin(Properties properties) {
        this.azureAuthenticationTemplate = new AzureAuthenticationTemplate();
        AuthProperty.SCOPES.setProperty(properties, OSSRDBMS_SCOPE);
        this.azureAuthenticationTemplate.init(properties);
    }

    AzureIdentityPostgresqlAuthenticationPlugin(AzureAuthenticationTemplate azureAuthenticationTemplate, Properties properties) {
        this.azureAuthenticationTemplate = azureAuthenticationTemplate;
        AuthProperty.SCOPES.setProperty(properties, OSSRDBMS_SCOPE);
        this.azureAuthenticationTemplate.init(properties);
    }

    public char[] getPassword(AuthenticationRequestType art) throws PSQLException {
        String password = this.azureAuthenticationTemplate.getTokenAsPassword();
        if (password != null) {
            return password.toCharArray();
        }
        throw new PSQLException("Unable to acquire access token", PSQLState.INVALID_PASSWORD);
    }

    AzureAuthenticationTemplate getAzureAuthenticationTemplate() {
        return this.azureAuthenticationTemplate;
    }
}

