/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenCredential;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.util.configuration.Configuration;
import com.azure.core.util.configuration.ConfigurationManager;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.credential.ClientSecretCredential;
import com.azure.identity.implementation.IdentityClientOptions;
import reactor.core.publisher.Mono;

public class EnvironmentCredential
implements TokenCredential {
    private final Configuration configuration;
    private final IdentityClientOptions identityClientOptions;
    private final ClientLogger logger = new ClientLogger(EnvironmentCredential.class);

    EnvironmentCredential(IdentityClientOptions identityClientOptions) {
        this.configuration = ConfigurationManager.getConfiguration().clone();
        this.identityClientOptions = identityClientOptions;
    }

    public Mono<AccessToken> getToken(String ... scopes) {
        return Mono.fromSupplier(() -> {
            if (this.configuration.contains("AZURE_CLIENT_ID") && this.configuration.contains("AZURE_CLIENT_SECRET") && this.configuration.contains("AZURE_TENANT_ID")) {
                return new ClientSecretCredential(this.configuration.get("AZURE_TENANT_ID"), this.configuration.get("AZURE_CLIENT_ID"), this.configuration.get("AZURE_CLIENT_SECRET"), this.identityClientOptions);
            }
            throw this.logger.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Cannot create any credentials with the current environment variables", null));
        }).flatMap(cred -> cred.getToken(scopes));
    }
}

