/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenCredential;
import com.azure.core.util.configuration.Configuration;
import com.azure.core.util.configuration.ConfigurationManager;
import com.azure.identity.credential.AppServiceMSICredential;
import com.azure.identity.credential.VirtualMachineMSICredential;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import reactor.core.publisher.Mono;

public final class ManagedIdentityCredential
implements TokenCredential {
    private final AppServiceMSICredential appServiceMSICredential;
    private final VirtualMachineMSICredential virtualMachineMSICredential;

    ManagedIdentityCredential(String clientId, IdentityClientOptions identityClientOptions) {
        IdentityClient identityClient = new IdentityClientBuilder().clientId(clientId).identityClientOptions(identityClientOptions).build();
        Configuration configuration = ConfigurationManager.getConfiguration();
        if (configuration.contains("MSI_ENDPOINT")) {
            this.appServiceMSICredential = new AppServiceMSICredential(clientId, identityClient);
            this.virtualMachineMSICredential = null;
        } else {
            this.virtualMachineMSICredential = new VirtualMachineMSICredential(clientId, identityClient);
            this.appServiceMSICredential = null;
        }
    }

    public String clientId() {
        return this.appServiceMSICredential != null ? this.appServiceMSICredential.clientId() : this.virtualMachineMSICredential.clientId();
    }

    public String msiEndpoint() {
        return this.appServiceMSICredential == null ? null : this.appServiceMSICredential.msiEndpoint();
    }

    public String msiSecret() {
        return this.appServiceMSICredential == null ? null : this.appServiceMSICredential.msiSecret();
    }

    public Mono<AccessToken> getToken(String ... scopes) {
        return this.appServiceMSICredential != null ? this.appServiceMSICredential.authenticate(scopes) : this.virtualMachineMSICredential.authenticate(scopes);
    }
}

