/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenCredential;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.MsalToken;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public class UsernamePasswordCredential
implements TokenCredential {
    private final String username;
    private final String password;
    private final IdentityClient identityClient;
    private final AtomicReference<MsalToken> cachedToken;

    UsernamePasswordCredential(String clientId, String username, String password, IdentityClientOptions identityClientOptions) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        this.username = username;
        this.password = password;
        this.identityClient = new IdentityClientBuilder().tenantId("common").clientId(clientId).identityClientOptions(identityClientOptions).build();
        this.cachedToken = new AtomicReference();
    }

    public Mono<AccessToken> getToken(String ... scopes) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithUserRefreshToken(scopes, this.cachedToken.get()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithUsernamePassword(scopes, this.username, this.password))).map(msalToken -> {
            this.cachedToken.set((MsalToken)((Object)msalToken));
            return msalToken;
        });
    }
}

