/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.credentials.AccessToken;
import com.azure.core.http.ProxyOptions;
import com.azure.core.implementation.serializer.SerializerAdapter;
import com.azure.core.implementation.serializer.SerializerEncoding;
import com.azure.core.implementation.serializer.jackson.JacksonAdapter;
import com.azure.core.implementation.util.ScopeUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.DeviceCodeChallenge;
import com.azure.identity.implementation.AuthorizationCodeListener;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.MSIToken;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.util.CertificateUtil;
import com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import java.awt.Desktop;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class IdentityClient {
    private static final SerializerAdapter SERIALIZER_ADAPTER = JacksonAdapter.createDefaultSerializerAdapter();
    private static final Random RANDOM = new Random();
    private final ClientLogger logger = new ClientLogger(IdentityClient.class);
    private final IdentityClientOptions options;
    private final PublicClientApplication publicClientApplication;
    private final String tenantId;
    private final String clientId;

    IdentityClient(String tenantId, String clientId, IdentityClientOptions options) {
        if (tenantId == null) {
            tenantId = "common";
        }
        if (options == null) {
            options = new IdentityClientOptions();
        }
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.options = options;
        if (clientId == null) {
            this.publicClientApplication = null;
        } else {
            String authorityUrl = options.authorityHost().replaceAll("/+$", "") + "/organizations/" + tenantId;
            PublicClientApplication.Builder publicClientApplicationBuilder = PublicClientApplication.builder((String)clientId);
            try {
                publicClientApplicationBuilder = (PublicClientApplication.Builder)publicClientApplicationBuilder.authority(authorityUrl);
            }
            catch (MalformedURLException e) {
                throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalStateException(e));
            }
            if (options.proxyOptions() != null) {
                publicClientApplicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(options.proxyOptions()));
            }
            this.publicClientApplication = publicClientApplicationBuilder.build();
        }
    }

    public Mono<AccessToken> authenticateWithClientSecret(String clientSecret, String[] scopes) {
        String authorityUrl = this.options.authorityHost().replaceAll("/+$", "") + "/" + this.tenantId;
        try {
            ConfidentialClientApplication.Builder applicationBuilder = (ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)ClientCredentialFactory.create((String)clientSecret)).authority(authorityUrl);
            if (this.options.proxyOptions() != null) {
                applicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(this.options.proxyOptions()));
            }
            ConfidentialClientApplication application = applicationBuilder.build();
            return Mono.fromFuture((CompletableFuture)application.acquireToken(ClientCredentialParameters.builder(new HashSet<String>(Arrays.asList(scopes))).build())).map(ar -> new AccessToken(ar.accessToken(), OffsetDateTime.ofInstant(ar.expiresOnDate().toInstant(), ZoneOffset.UTC)));
        }
        catch (MalformedURLException e) {
            return Mono.error((Throwable)e);
        }
    }

    public Mono<AccessToken> authenticateWithPfxCertificate(String pfxCertificatePath, String pfxCertificatePassword, String[] scopes) {
        String authorityUrl = this.options.authorityHost().replaceAll("/+$", "") + "/" + this.tenantId;
        try {
            ConfidentialClientApplication.Builder applicationBuilder = (ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)ClientCredentialFactory.create((InputStream)new FileInputStream(pfxCertificatePath), (String)pfxCertificatePassword)).authority(authorityUrl);
            if (this.options.proxyOptions() != null) {
                applicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(this.options.proxyOptions()));
            }
            ConfidentialClientApplication application = applicationBuilder.build();
            return Mono.fromFuture((CompletableFuture)application.acquireToken(ClientCredentialParameters.builder(new HashSet<String>(Arrays.asList(scopes))).build())).map(ar -> new AccessToken(ar.accessToken(), OffsetDateTime.ofInstant(ar.expiresOnDate().toInstant(), ZoneOffset.UTC)));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException e) {
            return Mono.error((Throwable)e);
        }
    }

    public Mono<AccessToken> authenticateWithPemCertificate(String pemCertificatePath, String[] scopes) {
        String authorityUrl = this.options.authorityHost().replaceAll("/+$", "") + "/" + this.tenantId;
        try {
            byte[] pemCertificateBytes = Files.readAllBytes(Paths.get(pemCertificatePath, new String[0]));
            ConfidentialClientApplication.Builder applicationBuilder = (ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)ClientCredentialFactory.create((PrivateKey)CertificateUtil.privateKeyFromPem(pemCertificateBytes), (X509Certificate)CertificateUtil.publicKeyFromPem(pemCertificateBytes))).authority(authorityUrl);
            if (this.options.proxyOptions() != null) {
                applicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(this.options.proxyOptions()));
            }
            ConfidentialClientApplication application = applicationBuilder.build();
            return Mono.fromFuture((CompletableFuture)application.acquireToken(ClientCredentialParameters.builder(new HashSet<String>(Arrays.asList(scopes))).build())).map(ar -> new AccessToken(ar.accessToken(), OffsetDateTime.ofInstant(ar.expiresOnDate().toInstant(), ZoneOffset.UTC)));
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    public Mono<MsalToken> authenticateWithUsernamePassword(String[] scopes, String username, String password) {
        return Mono.fromFuture((CompletableFuture)this.publicClientApplication.acquireToken(UserNamePasswordParameters.builder(new HashSet<String>(Arrays.asList(scopes)), (String)username, (char[])password.toCharArray()).build())).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithUserRefreshToken(String[] scopes, MsalToken msalToken) {
        SilentParameters parameters = msalToken.account() != null ? SilentParameters.builder(new HashSet<String>(Arrays.asList(scopes)), (IAccount)msalToken.account()).build() : SilentParameters.builder(new HashSet<String>(Arrays.asList(scopes))).build();
        return Mono.defer(() -> {
            try {
                return Mono.fromFuture((CompletableFuture)this.publicClientApplication.acquireTokenSilently(parameters)).map(MsalToken::new);
            }
            catch (MalformedURLException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    public Mono<MsalToken> authenticateWithDeviceCode(String[] scopes, Consumer<DeviceCodeChallenge> deviceCodeConsumer) {
        return Mono.fromFuture(() -> {
            DeviceCodeFlowParameters parameters = DeviceCodeFlowParameters.builder(new HashSet<String>(Arrays.asList(scopes)), dc -> deviceCodeConsumer.accept(new DeviceCodeChallenge(dc.userCode(), dc.deviceCode(), dc.verificationUri(), dc.expiresIn(), dc.interval(), dc.message()))).build();
            return this.publicClientApplication.acquireToken(parameters);
        }).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithAuthorizationCode(String[] scopes, String authorizationCode, URI redirectUri) {
        return Mono.fromFuture(() -> this.publicClientApplication.acquireToken(AuthorizationCodeParameters.builder((String)authorizationCode, (URI)redirectUri).scopes(new HashSet<String>(Arrays.asList(scopes))).build())).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithBrowserInteraction(String[] scopes, int port) {
        String authorityUrl = this.options.authorityHost().replaceAll("/+$", "") + "/common";
        return AuthorizationCodeListener.create(port).flatMap(server -> {
            URI browserUri;
            URI redirectUri;
            try {
                redirectUri = new URI(String.format("http://localhost:%s", port));
                browserUri = new URI(String.format("%s/oauth2/v2.0/authorize?response_type=code&response_mode=query&prompt=select_account&client_id=%s&redirect_uri=%s&state=%s&scope=%s", authorityUrl, this.clientId, redirectUri.toString(), UUID.randomUUID(), String.join((CharSequence)" ", scopes)));
            }
            catch (URISyntaxException e) {
                return server.dispose().then(Mono.error((Throwable)e));
            }
            return server.listen().mergeWith((Publisher)Mono.fromRunnable(() -> {
                try {
                    Desktop.getDesktop().browse(browserUri);
                }
                catch (IOException e) {
                    throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(e));
                }
            }).subscribeOn(Schedulers.newSingle((String)"browser"))).next().flatMap(code -> this.authenticateWithAuthorizationCode(scopes, (String)code, redirectUri)).onErrorResume(t -> server.dispose().then(Mono.error((Throwable)t))).flatMap(msalToken -> server.dispose().then(Mono.just((Object)msalToken)));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<AccessToken> authenticateToManagedIdentityEndpoint(String msiEndpoint, String msiSecret, String[] scopes) {
        String resource = ScopeUtil.scopesToResource((String[])scopes);
        HttpURLConnection connection = null;
        StringBuilder payload = new StringBuilder();
        try {
            payload.append("resource=");
            payload.append(URLEncoder.encode(resource, "UTF-8"));
            payload.append("&api-version=");
            payload.append(URLEncoder.encode("2017-09-01", "UTF-8"));
            if (this.clientId != null) {
                payload.append("&client_id=");
                payload.append(URLEncoder.encode(this.clientId, "UTF-8"));
            }
        }
        catch (IOException exception) {
            return Mono.error((Throwable)exception);
        }
        try {
            URL url = new URL(String.format("%s?%s", msiEndpoint, payload));
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            if (msiSecret != null) {
                connection.setRequestProperty("Secret", msiSecret);
            }
            connection.setRequestProperty("Metadata", "true");
            connection.connect();
            Scanner s = new Scanner(connection.getInputStream(), StandardCharsets.UTF_8.name()).useDelimiter("\\A");
            String result = s.hasNext() ? s.next() : "";
            Mono mono = Mono.just((Object)SERIALIZER_ADAPTER.deserialize(result, MSIToken.class, SerializerEncoding.JSON));
            return mono;
        }
        catch (IOException e) {
            Mono mono = Mono.error((Throwable)e);
            return mono;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<AccessToken> authenticateToIMDSEndpoint(String[] scopes) {
        String resource = ScopeUtil.scopesToResource((String[])scopes);
        StringBuilder payload = new StringBuilder();
        int imdsUpgradeTimeInMs = 70000;
        try {
            payload.append("api-version=");
            payload.append(URLEncoder.encode("2018-02-01", "UTF-8"));
            payload.append("&resource=");
            payload.append(URLEncoder.encode(resource, "UTF-8"));
            if (this.clientId != null) {
                payload.append("&client_id=");
                payload.append(URLEncoder.encode(this.clientId, "UTF-8"));
            }
        }
        catch (IOException exception) {
            return Mono.error((Throwable)exception);
        }
        int retry = 1;
        while (retry <= this.options.maxRetry()) {
            URL url = null;
            HttpURLConnection connection = null;
            try {
                url = new URL(String.format("http://169.254.169.254/metadata/identity/oauth2/token?%s", payload.toString()));
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Metadata", "true");
                connection.connect();
                Scanner s = new Scanner(connection.getInputStream(), StandardCharsets.UTF_8.name()).useDelimiter("\\A");
                String result = s.hasNext() ? s.next() : "";
                Mono mono = Mono.just((Object)SERIALIZER_ADAPTER.deserialize(result, MSIToken.class, SerializerEncoding.JSON));
                return mono;
            }
            catch (IOException exception) {
                if (connection == null) {
                    Mono result = Mono.error((Throwable)new RuntimeException(String.format("Could not connect to the url: %s.", url), exception));
                    return result;
                }
                int responseCode = 0;
                try {
                    responseCode = connection.getResponseCode();
                }
                catch (IOException e) {
                    Mono mono = Mono.error((Throwable)e);
                    return mono;
                }
                if (responseCode == 410 || responseCode == 429 || responseCode == 404 || responseCode >= 500 && responseCode <= 599) {
                    int retryTimeoutInMs = this.options.retryTimeout().apply(RANDOM.nextInt(retry));
                    int n = retryTimeoutInMs = responseCode == 410 && retryTimeoutInMs < 70000 ? 70000 : retryTimeoutInMs;
                    if (++retry > this.options.maxRetry()) break;
                    IdentityClient.sleep(retryTimeoutInMs);
                    continue;
                }
                Mono mono = Mono.error((Throwable)new RuntimeException("Couldn't acquire access token from IMDS, verify your objectId, clientId or msiResourceId", exception));
                return mono;
            }
            finally {
                if (connection == null) continue;
                connection.disconnect();
            }
        }
        return Mono.error((Throwable)new RuntimeException(String.format("MSI: Failed to acquire tokens after retrying %s times", this.options.maxRetry())));
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Proxy proxyOptionsToJavaNetProxy(ProxyOptions options) {
        switch (options.type()) {
            case SOCKS4: 
            case SOCKS5: {
                return new Proxy(Proxy.Type.SOCKS, options.address());
            }
        }
        return new Proxy(Proxy.Type.HTTP, options.address());
    }
}

