/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.msalextensions.cachepersister;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.msalextensions.CacheLock;
import com.azure.identity.implementation.msalextensions.CacheLockNotObtainedException;
import java.io.IOException;

public abstract class CacheProtectorBase {
    private String lockfileLocation;
    private CacheLock lock;
    private ClientLogger logger = new ClientLogger(CacheProtectorBase.class);

    public CacheProtectorBase(String lockfileLocation) {
        this.lockfileLocation = lockfileLocation;
        this.lock = new CacheLock(this.lockfileLocation);
    }

    public byte[] readCache() {
        byte[] contents = null;
        try {
            this.lock.lock();
        }
        catch (CacheLockNotObtainedException ex) {
            this.logger.error("readCache() - Issue in locking", new Object[0]);
            return contents;
        }
        try {
            contents = this.unprotect();
        }
        catch (IOException ex) {
            this.logger.error("readCache() - Issue in reading", new Object[0]);
        }
        this.lock.unlock();
        return contents;
    }

    public void writeCache(byte[] data) {
        try {
            this.lock.lock();
        }
        catch (CacheLockNotObtainedException e) {
            this.logger.error("writeCache() - Issue in locking", new Object[0]);
            return;
        }
        try {
            this.protect(data);
        }
        catch (IOException e) {
            this.logger.error("writeCache() - Issue in writing", new Object[0]);
        }
        this.lock.unlock();
    }

    protected byte[] unprotect() throws IOException {
        byte[] empty = new byte[]{};
        return empty;
    }

    protected void protect(byte[] data) throws IOException {
    }

    public boolean deleteCache() {
        try {
            this.lock.lock();
        }
        catch (CacheLockNotObtainedException e) {
            this.logger.error("deleteCache() - issue in locking", new Object[0]);
            return false;
        }
        this.deleteCacheHelper();
        this.lock.unlock();
        return true;
    }

    protected void deleteCacheHelper() {
    }
}

