/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenCredential;
import com.azure.core.credentials.TokenRequest;
import com.azure.core.exception.ClientAuthenticationException;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ChainedTokenCredential
implements TokenCredential {
    private final Deque<TokenCredential> credentials;

    ChainedTokenCredential(Deque<TokenCredential> credentials) {
        this.credentials = credentials;
    }

    public Mono<AccessToken> getToken(TokenRequest request) {
        AtomicReference cause = new AtomicReference();
        return Flux.fromIterable(this.credentials).flatMap(p -> p.getToken(request).onErrorResume(t -> {
            if (cause.get() != null) {
                t.initCause((Throwable)cause.get());
            }
            cause.set(t);
            return Mono.empty();
        })).next().switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)new ClientAuthenticationException("Tried " + this.credentials.stream().map(c -> c.getClass().getSimpleName()).collect(Collectors.joining(", ")) + " but failed to acquire a token for any of them. Please verify the environment for either of them and see more details in the causes below.", null, (Throwable)cause.get()))));
    }
}

