/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenCredential;
import com.azure.core.credentials.TokenRequest;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class ClientSecretCredential
implements TokenCredential {
    private final String clientSecret;
    private final IdentityClient identityClient;

    ClientSecretCredential(String tenantId, String clientId, String clientSecret, IdentityClientOptions identityClientOptions) {
        Objects.requireNonNull(clientSecret);
        Objects.requireNonNull(identityClientOptions);
        this.identityClient = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).identityClientOptions(identityClientOptions).build();
        this.clientSecret = clientSecret;
    }

    public Mono<AccessToken> getToken(TokenRequest request) {
        return this.identityClient.authenticateWithClientSecret(this.clientSecret, request);
    }
}

