/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenCredential;
import com.azure.core.credentials.TokenRequest;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.MsalToken;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public class InteractiveBrowserCredential
implements TokenCredential {
    private final int port;
    private final IdentityClient identityClient;
    private final AtomicReference<MsalToken> cachedToken;

    InteractiveBrowserCredential(String clientId, String tenantId, int port, IdentityClientOptions identityClientOptions) {
        this.port = port;
        if (tenantId == null) {
            tenantId = "common";
        }
        this.identityClient = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).identityClientOptions(identityClientOptions).build();
        this.cachedToken = new AtomicReference();
    }

    public Mono<AccessToken> getToken(TokenRequest request) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithUserRefreshToken(request, this.cachedToken.get()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithBrowserInteraction(request, this.port))).map(msalToken -> {
            this.cachedToken.set((MsalToken)((Object)msalToken));
            return msalToken;
        });
    }
}

