/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.msalextensions;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.msalextensions.cachepersister.CachePersister;
import com.azure.identity.implementation.msalextensions.cachepersister.PlatformNotSupportedException;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.ITokenCacheAccessContext;
import java.io.UnsupportedEncodingException;

public class PersistentTokenCacheAccessAspect
implements ITokenCacheAccessAspect {
    private CachePersister cachePersister;
    private ClientLogger logger;

    public PersistentTokenCacheAccessAspect() throws RuntimeException, PlatformNotSupportedException {
        this.logger = new ClientLogger(PersistentTokenCacheAccessAspect.class);
        this.cachePersister = new CachePersister.Builder().build();
    }

    public PersistentTokenCacheAccessAspect(CachePersister customCachePersister) {
        this.cachePersister = customCachePersister;
    }

    public void beforeCacheAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        String data;
        byte[] bytes = this.cachePersister.readCache();
        try {
            data = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            data = "";
        }
        iTokenCacheAccessContext.tokenCache().deserialize(data);
    }

    public void afterCacheAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        if (iTokenCacheAccessContext.hasCacheChanged()) {
            String newData = iTokenCacheAccessContext.tokenCache().serialize();
            try {
                this.cachePersister.writeCache(newData.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("was not able to write to cache", new Object[0]);
            }
        }
    }

    public void deleteCache() {
        this.cachePersister.deleteCache();
    }
}

