/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenCredential;
import com.azure.core.credentials.TokenRequest;
import com.azure.core.util.Configuration;
import com.azure.identity.credential.AppServiceMSICredential;
import com.azure.identity.credential.VirtualMachineMSICredential;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import reactor.core.publisher.Mono;

public final class ManagedIdentityCredential
implements TokenCredential {
    private final AppServiceMSICredential appServiceMSICredential;
    private final VirtualMachineMSICredential virtualMachineMSICredential;

    ManagedIdentityCredential(String clientId, IdentityClientOptions identityClientOptions) {
        IdentityClient identityClient = new IdentityClientBuilder().clientId(clientId).identityClientOptions(identityClientOptions).build();
        Configuration configuration = Configuration.getGlobalConfiguration();
        if (configuration.contains("MSI_ENDPOINT")) {
            this.appServiceMSICredential = new AppServiceMSICredential(clientId, identityClient);
            this.virtualMachineMSICredential = null;
        } else {
            this.virtualMachineMSICredential = new VirtualMachineMSICredential(clientId, identityClient);
            this.appServiceMSICredential = null;
        }
    }

    public String getClientId() {
        return this.appServiceMSICredential != null ? this.appServiceMSICredential.getClientId() : this.virtualMachineMSICredential.getClientId();
    }

    public String getMsiEndpoint() {
        return this.appServiceMSICredential == null ? null : this.appServiceMSICredential.getMsiEndpoint();
    }

    public String getMsiSecret() {
        return this.appServiceMSICredential == null ? null : this.appServiceMSICredential.getMsiSecret();
    }

    public Mono<AccessToken> getToken(TokenRequest request) {
        return this.appServiceMSICredential != null ? this.appServiceMSICredential.authenticate(request) : this.virtualMachineMSICredential.authenticate(request);
    }
}

