/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ChainedTokenCredential
implements TokenCredential {
    private final Deque<TokenCredential> credentials;

    ChainedTokenCredential(Deque<TokenCredential> credentials) {
        this.credentials = credentials;
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        AtomicReference cause = new AtomicReference();
        return Flux.fromIterable(this.credentials).flatMap(p -> p.getToken(request).onErrorResume(t -> {
            if (cause.get() != null) {
                t.initCause((Throwable)cause.get());
            }
            cause.set(t);
            return Mono.empty();
        })).next().switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)new RuntimeException("Tried " + this.credentials.stream().map(c -> c.getClass().getSimpleName()).collect(Collectors.joining(", ")) + " but failed to acquire a token for any of them. Please verify the environment for either of them and see more details in the causes below.", (Throwable)cause.get()))));
    }
}

