/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class ClientCertificateCredential
implements TokenCredential {
    private final String clientCertificate;
    private final String clientCertificatePassword;
    private final IdentityClient identityClient;

    ClientCertificateCredential(String tenantId, String clientId, String certificatePath, String certificatePassword, IdentityClientOptions identityClientOptions) {
        Objects.requireNonNull(certificatePath, "'certificatePath' cannot be null.");
        this.clientCertificate = certificatePath;
        this.clientCertificatePassword = certificatePassword;
        this.identityClient = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).identityClientOptions(identityClientOptions).build();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        if (this.clientCertificatePassword != null) {
            return this.identityClient.authenticateWithPfxCertificate(this.clientCertificate, this.clientCertificatePassword, request);
        }
        return this.identityClient.authenticateWithPemCertificate(this.clientCertificate, request);
    }
}

