/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.identity.implementation.IdentityClient;
import reactor.core.publisher.Mono;

class AppServiceMsiCredential {
    private final String msiEndpoint;
    private final String msiSecret;
    private final IdentityClient identityClient;
    private final String clientId;

    AppServiceMsiCredential(String clientId, IdentityClient identityClient) {
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.msiEndpoint = configuration.get("MSI_ENDPOINT");
        this.msiSecret = configuration.get("MSI_SECRET");
        this.identityClient = identityClient;
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Mono<AccessToken> authenticate(TokenRequestContext request) {
        return this.identityClient.authenticateToManagedIdentityEndpoint(this.msiEndpoint, this.msiSecret, request);
    }
}

