/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.msalextensions.PersistentTokenCacheAccessAspect;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SilentParameters;
import java.net.MalformedURLException;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class SharedTokenCacheCredential
implements TokenCredential {
    private final String username;
    private final String clientId;
    private final String tenantId;
    private final IdentityClientOptions options;
    private PublicClientApplication pubClient = null;

    SharedTokenCacheCredential(String username, String clientId, String tenantId, IdentityClientOptions identityClientOptions) {
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.username = username == null ? configuration.get("AZURE_USERNAME") : username;
        this.clientId = clientId == null ? configuration.get("AZURE_CLIENT_ID") : clientId;
        this.tenantId = tenantId == null ? (configuration.contains("AZURE_TENANT_ID") ? configuration.get("AZURE_TENANT_ID") : "common") : tenantId;
        this.options = identityClientOptions;
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        String authorityUrl = this.options.getAuthorityHost().replaceAll("/+$", "") + "/" + this.tenantId + "/";
        if (this.pubClient == null) {
            try {
                PersistentTokenCacheAccessAspect accessAspect = new PersistentTokenCacheAccessAspect();
                this.pubClient = ((PublicClientApplication.Builder)((PublicClientApplication.Builder)PublicClientApplication.builder((String)this.clientId).authority(authorityUrl)).setTokenCacheAccessAspect((ITokenCacheAccessAspect)accessAspect)).build();
            }
            catch (MalformedURLException e) {
                return Mono.error((Throwable)e);
            }
        }
        return Mono.fromFuture((CompletableFuture)this.pubClient.getAccounts()).flatMap(set -> {
            HashMap<String, IAccount> accounts = new HashMap<String, IAccount>();
            for (IAccount cached : set) {
                if (this.username != null && !this.username.equals(cached.username()) || accounts.containsKey(cached.homeAccountId())) continue;
                accounts.put(cached.homeAccountId(), cached);
            }
            if (accounts.size() == 0) {
                if (this.username == null) {
                    return Mono.error((Throwable)new RuntimeException("No accounts were discovered in the shared token cache. To fix, authenticate through tooling supporting azure developer sign on."));
                }
                return Mono.error((Throwable)new RuntimeException(String.format("User account '%s' was not found in the shared token cache. Discovered Accounts: [ '%s' ]", this.username, set.stream().map(IAccount::username).distinct().collect(Collectors.joining(", ")))));
            }
            if (accounts.size() > 1) {
                if (this.username == null) {
                    return Mono.error((Throwable)new RuntimeException("Multiple accounts were discovered in the shared token cache. To fix, set the AZURE_USERNAME and AZURE_TENANT_ID environment variable to the preferred username, or specify it when constructing SharedTokenCacheCredential."));
                }
                return Mono.error((Throwable)new RuntimeException("Multiple entries for the user account " + this.username + " were found in the shared token cache. This is not currently supported by the SharedTokenCacheCredential."));
            }
            IAccount requestedAccount = (IAccount)accounts.values().iterator().next();
            SilentParameters params = SilentParameters.builder(new HashSet(request.getScopes()), (IAccount)requestedAccount).authorityUrl(authorityUrl).build();
            try {
                CompletableFuture future = this.pubClient.acquireTokenSilently(params);
                return Mono.fromFuture(() -> future).map(result -> new AccessToken(result.accessToken(), result.expiresOnDate().toInstant().atOffset(ZoneOffset.UTC)));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return Mono.error((Throwable)new RuntimeException("Token was not found"));
            }
        });
    }
}

