/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.ProxyOptions;
import java.time.Duration;
import java.util.function.Function;

public final class IdentityClientOptions {
    private static final String DEFAULT_AUTHORITY_HOST = "https://login.microsoftonline.com/";
    private static final int MAX_RETRY_DEFAULT_LIMIT = 3;
    private String authorityHost = "https://login.microsoftonline.com/";
    private int maxRetry = 3;
    private Function<Duration, Duration> retryTimeout = i -> Duration.ofSeconds((long)Math.pow(2.0, i.getSeconds() - 1L));
    private ProxyOptions proxyOptions;
    private HttpPipeline httpPipeline;

    public String getAuthorityHost() {
        return this.authorityHost;
    }

    public IdentityClientOptions setAuthorityHost(String authorityHost) {
        this.authorityHost = authorityHost;
        return this;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public IdentityClientOptions setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
        return this;
    }

    public Function<Duration, Duration> getRetryTimeout() {
        return this.retryTimeout;
    }

    public IdentityClientOptions setRetryTimeout(Function<Duration, Duration> retryTimeout) {
        this.retryTimeout = retryTimeout;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public IdentityClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public IdentityClientOptions setHttpPipeline(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        return this;
    }
}

