/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.ProxyOptions;
import com.azure.identity.implementation.IdentityClientOptions;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

public abstract class CredentialBuilderBase<T extends CredentialBuilderBase<T>> {
    IdentityClientOptions identityClientOptions = new IdentityClientOptions();

    CredentialBuilderBase() {
    }

    public T maxRetry(int maxRetry) {
        this.identityClientOptions.setMaxRetry(maxRetry);
        return (T)this;
    }

    public T retryTimeout(Function<Duration, Duration> retryTimeout) {
        this.identityClientOptions.setRetryTimeout(retryTimeout);
        return (T)this;
    }

    @Deprecated
    public T proxyOptions(ProxyOptions proxyOptions) {
        this.identityClientOptions.setProxyOptions(proxyOptions);
        return (T)this;
    }

    public T httpPipeline(HttpPipeline httpPipeline) {
        this.identityClientOptions.setHttpPipeline(httpPipeline);
        return (T)this;
    }

    public T httpClient(HttpClient client) {
        Objects.requireNonNull(client);
        this.identityClientOptions.setHttpClient(client);
        return (T)this;
    }

    public T tokenRefreshOffset(Duration tokenRefreshOffset) {
        this.identityClientOptions.setTokenRefreshOffset(tokenRefreshOffset);
        return (T)this;
    }
}

