/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AzureCliCredential;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.EnvironmentCredential;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.SharedTokenCacheCredential;
import java.util.ArrayDeque;
import java.util.concurrent.ExecutorService;

public class DefaultAzureCredentialBuilder
extends CredentialBuilderBase<DefaultAzureCredentialBuilder> {
    private boolean excludeEnvironmentCredential;
    private boolean excludeManagedIdentityCredential;
    private boolean excludeSharedTokenCacheCredential;
    private boolean excludeAzureCliCredential;
    private final ClientLogger logger = new ClientLogger(DefaultAzureCredentialBuilder.class);

    public DefaultAzureCredentialBuilder authorityHost(String authorityHost) {
        this.identityClientOptions.setAuthorityHost(authorityHost);
        return this;
    }

    public DefaultAzureCredentialBuilder excludeEnvironmentCredential() {
        this.excludeEnvironmentCredential = true;
        return this;
    }

    public DefaultAzureCredentialBuilder excludeManagedIdentityCredential() {
        this.excludeManagedIdentityCredential = true;
        return this;
    }

    public DefaultAzureCredentialBuilder excludeSharedTokenCacheCredential() {
        this.excludeSharedTokenCacheCredential = true;
        return this;
    }

    public DefaultAzureCredentialBuilder excludeAzureCliCredential() {
        this.excludeAzureCliCredential = true;
        return this;
    }

    public DefaultAzureCredentialBuilder executorService(ExecutorService executorService) {
        this.identityClientOptions.setExecutorService(executorService);
        return this;
    }

    public DefaultAzureCredential build() {
        return new DefaultAzureCredential(this.getCredentialsChain());
    }

    private ArrayDeque<TokenCredential> getCredentialsChain() {
        ArrayDeque<TokenCredential> output = new ArrayDeque<TokenCredential>(4);
        if (!this.excludeEnvironmentCredential) {
            output.add(new EnvironmentCredential(this.identityClientOptions));
        }
        if (!this.excludeManagedIdentityCredential) {
            output.add(new ManagedIdentityCredential(null, this.identityClientOptions));
        }
        if (!this.excludeSharedTokenCacheCredential) {
            output.add(new SharedTokenCacheCredential(null, "04b07795-8ddb-461a-bbee-02f9e1bf7b46", null, this.identityClientOptions));
        }
        if (!this.excludeAzureCliCredential) {
            output.add(new AzureCliCredential(this.identityClientOptions));
        }
        if (output.size() == 0) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("At least one credential type must be included in the authentication flow."));
        }
        return output;
    }
}

