/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.ClientCertificateCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.UsernamePasswordCredential;
import com.azure.identity.implementation.IdentityClientOptions;
import reactor.core.publisher.Mono;

public class EnvironmentCredential
implements TokenCredential {
    private final Configuration configuration;
    private final IdentityClientOptions identityClientOptions;
    private final ClientLogger logger = new ClientLogger(EnvironmentCredential.class);

    EnvironmentCredential(IdentityClientOptions identityClientOptions) {
        this.configuration = Configuration.getGlobalConfiguration().clone();
        this.identityClientOptions = identityClientOptions;
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.fromSupplier(() -> {
            String clientId = this.configuration.get("AZURE_CLIENT_ID");
            String tenantId = this.configuration.get("AZURE_TENANT_ID");
            String clientSecret = this.configuration.get("AZURE_CLIENT_SECRET");
            String certPath = this.configuration.get("AZURE_CLIENT_CERTIFICATE_PATH");
            String username = this.configuration.get("AZURE_USERNAME");
            String password = this.configuration.get("AZURE_PASSWORD");
            if (this.verifyNotNull(clientId)) {
                if (this.verifyNotNull(tenantId, clientSecret)) {
                    return new ClientSecretCredential(tenantId, clientId, clientSecret, this.identityClientOptions);
                }
                if (this.verifyNotNull(tenantId, certPath)) {
                    return new ClientCertificateCredential(tenantId, clientId, certPath, null, this.identityClientOptions);
                }
                if (this.verifyNotNull(username, password)) {
                    return new UsernamePasswordCredential(clientId, tenantId, username, password, this.identityClientOptions);
                }
            }
            throw this.logger.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Cannot create any credentials with the current environment variables", null));
        }).flatMap(cred -> cred.getToken(request));
    }

    private boolean verifyNotNull(String ... configs) {
        for (String config : configs) {
            if (config != null) continue;
            return false;
        }
        return true;
    }
}

