/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.identity.AppServiceMsiCredential;
import com.azure.identity.VirtualMachineMsiCredential;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import reactor.core.publisher.Mono;

public final class ManagedIdentityCredential
implements TokenCredential {
    private final AppServiceMsiCredential appServiceMSICredential;
    private final VirtualMachineMsiCredential virtualMachineMSICredential;

    ManagedIdentityCredential(String clientId, IdentityClientOptions identityClientOptions) {
        IdentityClient identityClient = new IdentityClientBuilder().clientId(clientId).identityClientOptions(identityClientOptions).build();
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        if (configuration.contains("MSI_ENDPOINT")) {
            this.appServiceMSICredential = new AppServiceMsiCredential(clientId, identityClient);
            this.virtualMachineMSICredential = null;
        } else {
            this.virtualMachineMSICredential = new VirtualMachineMsiCredential(clientId, identityClient);
            this.appServiceMSICredential = null;
        }
    }

    public String getClientId() {
        return this.appServiceMSICredential != null ? this.appServiceMSICredential.getClientId() : this.virtualMachineMSICredential.getClientId();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return this.appServiceMSICredential != null ? this.appServiceMSICredential.authenticate(request) : this.virtualMachineMSICredential.authenticate(request);
    }
}

