/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.microsoft.aad.msal4j.HttpRequest;
import com.microsoft.aad.msal4j.HttpResponse;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.IHttpResponse;
import java.util.Collections;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class HttpPipelineAdapter
implements IHttpClient {
    private final HttpPipeline httpPipeline;

    HttpPipelineAdapter(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
    }

    public IHttpResponse send(HttpRequest httpRequest) throws Exception {
        com.azure.core.http.HttpRequest request = new com.azure.core.http.HttpRequest(HttpMethod.valueOf((String)httpRequest.httpMethod().name()), httpRequest.url());
        if (httpRequest.headers() != null) {
            request.setHeaders(new HttpHeaders(httpRequest.headers()));
        }
        if (httpRequest.body() != null) {
            request.setBody(httpRequest.body());
        }
        return (IHttpResponse)this.httpPipeline.send(request).flatMap(response -> response.getBodyAsString().map(body -> {
            HttpResponse httpResponse = new HttpResponse().body(body).statusCode(response.getStatusCode());
            httpResponse.headers(response.getHeaders().stream().collect(Collectors.toMap(HttpHeader::getName, h -> Collections.singletonList(h.getValue()))));
            return httpResponse;
        }).switchIfEmpty(Mono.defer(() -> {
            HttpResponse httpResponse = new HttpResponse().statusCode(response.getStatusCode());
            httpResponse.headers(response.getHeaders().stream().collect(Collectors.toMap(HttpHeader::getName, h -> Collections.singletonList(h.getValue()))));
            return Mono.just((Object)httpResponse);
        }))).block();
    }
}

