/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.identity.DeviceCodeInfo;
import com.azure.identity.implementation.AuthorizationCodeListener;
import com.azure.identity.implementation.HttpPipelineAdapter;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.IdentityToken;
import com.azure.identity.implementation.MSIToken;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.ScopeUtil;
import com.azure.identity.implementation.util.CertificateUtil;
import com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class IdentityClient {
    private static final SerializerAdapter SERIALIZER_ADAPTER = JacksonAdapter.createDefaultSerializerAdapter();
    private static final Random RANDOM = new Random();
    private static final String WINDOWS_STARTER = "cmd.exe";
    private static final String LINUX_MAC_STARTER = "/bin/sh";
    private static final String WINDOWS_SWITCHER = "/c";
    private static final String LINUX_MAC_SWITCHER = "-c";
    private static final String WINDOWS_PROCESS_ERROR_MESSAGE = "'az' is not recognized";
    private static final String LINUX_MAC_PROCESS_ERROR_MESSAGE = "(.*)az:(.*)not found";
    private static final String DEFAULT_WINDOWS_SYSTEM_ROOT = System.getenv("SystemRoot");
    private static final String DEFAULT_MAC_LINUX_PATH = "/bin/";
    private final ClientLogger logger = new ClientLogger(IdentityClient.class);
    private final IdentityClientOptions options;
    private final PublicClientApplication publicClientApplication;
    private final String tenantId;
    private final String clientId;
    private HttpPipelineAdapter httpPipelineAdapter;

    IdentityClient(String tenantId, String clientId, IdentityClientOptions options) {
        if (tenantId == null) {
            tenantId = "common";
        }
        if (options == null) {
            options = new IdentityClientOptions();
        }
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.options = options;
        if (clientId == null) {
            this.publicClientApplication = null;
        } else {
            String authorityUrl = options.getAuthorityHost().replaceAll("/+$", "") + "/organizations/" + tenantId;
            PublicClientApplication.Builder publicClientApplicationBuilder = PublicClientApplication.builder((String)clientId);
            try {
                publicClientApplicationBuilder = (PublicClientApplication.Builder)publicClientApplicationBuilder.authority(authorityUrl);
            }
            catch (MalformedURLException e) {
                throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalStateException(e));
            }
            HttpPipeline httpPipeline = options.getHttpPipeline();
            if (httpPipeline != null) {
                this.httpPipelineAdapter = new HttpPipelineAdapter(httpPipeline);
                publicClientApplicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
            } else {
                HttpClient httpClient = options.getHttpClient();
                if (httpClient != null) {
                    this.httpPipelineAdapter = new HttpPipelineAdapter(this.setupPipeline(httpClient));
                    publicClientApplicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
                } else if (options.getProxyOptions() != null) {
                    publicClientApplicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(options.getProxyOptions()));
                } else {
                    this.httpPipelineAdapter = new HttpPipelineAdapter(this.setupPipeline(HttpClient.createDefault()));
                    publicClientApplicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
                }
            }
            if (options.getExecutorService() != null) {
                publicClientApplicationBuilder.executorService(options.getExecutorService());
            }
            this.publicClientApplication = publicClientApplicationBuilder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<AccessToken> authenticateWithAzureCli(TokenRequestContext request) {
        String azCommand = "az account get-access-token --output json --resource ";
        StringBuilder command = new StringBuilder();
        command.append(azCommand);
        String scopes = ScopeUtil.scopesToResource(request.getScopes());
        try {
            ScopeUtil.validateScope(scopes);
        }
        catch (IllegalArgumentException ex) {
            return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)ex));
        }
        command.append(scopes);
        IdentityToken token = null;
        BufferedReader reader = null;
        try {
            String line;
            String switcher;
            String starter;
            if (this.isWindowsPlatform()) {
                starter = WINDOWS_STARTER;
                switcher = WINDOWS_SWITCHER;
            } else {
                starter = LINUX_MAC_STARTER;
                switcher = LINUX_MAC_SWITCHER;
            }
            ProcessBuilder builder = new ProcessBuilder(starter, switcher, command.toString());
            String workingDirectory = this.getSafeWorkingDirectory();
            if (workingDirectory == null) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("A Safe Working directory could not be found to execute CLI command from."));
            }
            builder.directory(new File(workingDirectory));
            builder.redirectErrorStream(true);
            Process process = builder.start();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(WINDOWS_PROCESS_ERROR_MESSAGE) || line.matches(LINUX_MAC_PROCESS_ERROR_MESSAGE)) {
                    throw this.logger.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Azure CLI not installed", null));
                }
                output.append(line);
            }
            String processOutput = output.toString();
            process.waitFor(10L, TimeUnit.SECONDS);
            if (process.exitValue() != 0) {
                if (processOutput.length() > 0) {
                    String redactedOutput = this.redactInfo("\"accessToken\": \"(.*?)(\"|$)", processOutput);
                    throw this.logger.logExceptionAsError((RuntimeException)new ClientAuthenticationException(redactedOutput, null));
                }
                throw this.logger.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Failed to invoke Azure CLI ", null));
            }
            Map objectMap = (Map)SERIALIZER_ADAPTER.deserialize(processOutput, Map.class, SerializerEncoding.JSON);
            String accessToken = (String)objectMap.get("accessToken");
            String time = (String)objectMap.get("expiresOn");
            String timeToSecond = time.substring(0, time.indexOf("."));
            String timeJoinedWithT = String.join((CharSequence)"T", timeToSecond.split(" "));
            OffsetDateTime expiresOn = LocalDateTime.parse(timeJoinedWithT, DateTimeFormatter.ISO_LOCAL_DATE_TIME).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
            token = new IdentityToken(accessToken, expiresOn, this.options);
        }
        catch (IOException | InterruptedException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
        catch (RuntimeException e) {
            Mono mono = Mono.error((Throwable)this.logger.logExceptionAsError(e));
            return mono;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(ex)));
            }
        }
        return Mono.just((Object)((Object)token));
    }

    public Mono<AccessToken> authenticateWithClientSecret(String clientSecret, TokenRequestContext request) {
        String authorityUrl = this.options.getAuthorityHost().replaceAll("/+$", "") + "/" + this.tenantId;
        try {
            ConfidentialClientApplication.Builder applicationBuilder = (ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)ClientCredentialFactory.createFromSecret((String)clientSecret)).authority(authorityUrl);
            if (this.httpPipelineAdapter != null) {
                applicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
            } else if (this.options.getProxyOptions() != null) {
                applicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
            }
            if (this.options.getExecutorService() != null) {
                applicationBuilder.executorService(this.options.getExecutorService());
            }
            ConfidentialClientApplication application = applicationBuilder.build();
            return Mono.fromFuture((CompletableFuture)application.acquireToken(ClientCredentialParameters.builder(new HashSet(request.getScopes())).build())).map(ar -> new MsalToken((IAuthenticationResult)ar, this.options));
        }
        catch (MalformedURLException e) {
            return Mono.error((Throwable)e);
        }
    }

    private HttpPipeline setupPipeline(HttpClient httpClient) {
        ArrayList<Object> policies = new ArrayList<Object>();
        HttpLogOptions httpLogOptions = new HttpLogOptions();
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(new RetryPolicy());
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(httpLogOptions));
        return new HttpPipelineBuilder().httpClient(httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
    }

    public Mono<AccessToken> authenticateWithPfxCertificate(String pfxCertificatePath, String pfxCertificatePassword, TokenRequestContext request) {
        String authorityUrl = this.options.getAuthorityHost().replaceAll("/+$", "") + "/" + this.tenantId;
        return Mono.fromCallable(() -> {
            ConfidentialClientApplication.Builder applicationBuilder = (ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)ClientCredentialFactory.createFromCertificate((InputStream)new FileInputStream(pfxCertificatePath), (String)pfxCertificatePassword)).authority(authorityUrl);
            if (this.httpPipelineAdapter != null) {
                applicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
            } else if (this.options.getProxyOptions() != null) {
                applicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
            }
            if (this.options.getExecutorService() != null) {
                applicationBuilder.executorService(this.options.getExecutorService());
            }
            return applicationBuilder.build();
        }).flatMap(application -> Mono.fromFuture((CompletableFuture)application.acquireToken(ClientCredentialParameters.builder(new HashSet(request.getScopes())).build()))).map(ar -> new MsalToken((IAuthenticationResult)ar, this.options));
    }

    public Mono<AccessToken> authenticateWithPemCertificate(String pemCertificatePath, TokenRequestContext request) {
        String authorityUrl = this.options.getAuthorityHost().replaceAll("/+$", "") + "/" + this.tenantId;
        try {
            byte[] pemCertificateBytes = Files.readAllBytes(Paths.get(pemCertificatePath, new String[0]));
            ConfidentialClientApplication.Builder applicationBuilder = (ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)ClientCredentialFactory.createFromCertificate((PrivateKey)CertificateUtil.privateKeyFromPem(pemCertificateBytes), (X509Certificate)CertificateUtil.publicKeyFromPem(pemCertificateBytes))).authority(authorityUrl);
            if (this.httpPipelineAdapter != null) {
                applicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
            } else if (this.options.getProxyOptions() != null) {
                applicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
            }
            if (this.options.getExecutorService() != null) {
                applicationBuilder.executorService(this.options.getExecutorService());
            }
            ConfidentialClientApplication application = applicationBuilder.build();
            return Mono.fromFuture((CompletableFuture)application.acquireToken(ClientCredentialParameters.builder(new HashSet(request.getScopes())).build())).map(ar -> new MsalToken((IAuthenticationResult)ar, this.options));
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    public Mono<MsalToken> authenticateWithUsernamePassword(TokenRequestContext request, String username, String password) {
        return Mono.fromFuture((CompletableFuture)this.publicClientApplication.acquireToken(UserNamePasswordParameters.builder(new HashSet(request.getScopes()), (String)username, (char[])password.toCharArray()).build())).map(ar -> new MsalToken((IAuthenticationResult)ar, this.options));
    }

    public Mono<MsalToken> authenticateWithUserRefreshToken(TokenRequestContext request, MsalToken msalToken) {
        SilentParameters parameters = msalToken.getAccount() != null ? SilentParameters.builder(new HashSet(request.getScopes()), (IAccount)msalToken.getAccount()).build() : SilentParameters.builder(new HashSet(request.getScopes())).build();
        return Mono.defer(() -> {
            try {
                return Mono.fromFuture((CompletableFuture)this.publicClientApplication.acquireTokenSilently(parameters)).map(ar -> new MsalToken((IAuthenticationResult)ar, this.options));
            }
            catch (MalformedURLException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    public Mono<MsalToken> authenticateWithDeviceCode(TokenRequestContext request, Consumer<DeviceCodeInfo> deviceCodeConsumer) {
        return Mono.fromFuture(() -> {
            DeviceCodeFlowParameters parameters = DeviceCodeFlowParameters.builder(new HashSet(request.getScopes()), dc -> deviceCodeConsumer.accept(new DeviceCodeInfo(dc.userCode(), dc.deviceCode(), dc.verificationUri(), OffsetDateTime.now().plusSeconds(dc.expiresIn()), dc.message()))).build();
            return this.publicClientApplication.acquireToken(parameters);
        }).map(ar -> new MsalToken((IAuthenticationResult)ar, this.options));
    }

    public Mono<MsalToken> authenticateWithAuthorizationCode(TokenRequestContext request, String authorizationCode, URI redirectUrl) {
        return Mono.fromFuture(() -> this.publicClientApplication.acquireToken(AuthorizationCodeParameters.builder((String)authorizationCode, (URI)redirectUrl).scopes(new HashSet(request.getScopes())).build())).map(ar -> new MsalToken((IAuthenticationResult)ar, this.options));
    }

    public Mono<MsalToken> authenticateWithBrowserInteraction(TokenRequestContext request, int port) {
        String authorityUrl = this.options.getAuthorityHost().replaceAll("/+$", "") + "/" + this.tenantId;
        return AuthorizationCodeListener.create(port).flatMap(server -> {
            String browserUri;
            URI redirectUri;
            try {
                redirectUri = new URI(String.format("http://localhost:%s", port));
                browserUri = String.format("%s/oauth2/v2.0/authorize?response_type=code&response_mode=query&prompt=select_account&client_id=%s&redirect_uri=%s&state=%s&scope=%s", authorityUrl, this.clientId, redirectUri.toString(), UUID.randomUUID(), String.join((CharSequence)" ", request.getScopes()));
            }
            catch (URISyntaxException e) {
                return server.dispose().then(Mono.error((Throwable)e));
            }
            return server.listen().mergeWith((Publisher)Mono.fromRunnable(() -> {
                try {
                    this.openUrl(browserUri);
                }
                catch (IOException e) {
                    throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(e));
                }
            }).subscribeOn(Schedulers.newSingle((String)"browser"))).next().flatMap(code -> this.authenticateWithAuthorizationCode(request, (String)code, redirectUri)).onErrorResume(t -> server.dispose().then(Mono.error((Throwable)t))).flatMap(msalToken -> server.dispose().then(Mono.just((Object)msalToken)));
        });
    }

    public Mono<AccessToken> authenticateToManagedIdentityEndpoint(String msiEndpoint, String msiSecret, TokenRequestContext request) {
        return Mono.fromCallable(() -> {
            String resource = ScopeUtil.scopesToResource(request.getScopes());
            HttpURLConnection connection = null;
            StringBuilder payload = new StringBuilder();
            payload.append("resource=");
            payload.append(URLEncoder.encode(resource, "UTF-8"));
            payload.append("&api-version=");
            payload.append(URLEncoder.encode("2017-09-01", "UTF-8"));
            if (this.clientId != null) {
                payload.append("&clientid=");
                payload.append(URLEncoder.encode(this.clientId, "UTF-8"));
            }
            try {
                URL url = new URL(String.format("%s?%s", msiEndpoint, payload));
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                if (msiSecret != null) {
                    connection.setRequestProperty("Secret", msiSecret);
                }
                connection.setRequestProperty("Metadata", "true");
                connection.connect();
                Scanner s = new Scanner(connection.getInputStream(), StandardCharsets.UTF_8.name()).useDelimiter("\\A");
                String result = s.hasNext() ? s.next() : "";
                MSIToken msiToken = (MSIToken)((Object)((Object)SERIALIZER_ADAPTER.deserialize(result, MSIToken.class, SerializerEncoding.JSON)));
                IdentityToken identityToken = new IdentityToken(msiToken.getToken(), msiToken.getExpiresAt(), this.options);
                return identityToken;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        });
    }

    public Mono<AccessToken> authenticateToIMDSEndpoint(TokenRequestContext request) {
        String resource = ScopeUtil.scopesToResource(request.getScopes());
        StringBuilder payload = new StringBuilder();
        int imdsUpgradeTimeInMs = 70000;
        try {
            payload.append("api-version=");
            payload.append(URLEncoder.encode("2018-02-01", "UTF-8"));
            payload.append("&resource=");
            payload.append(URLEncoder.encode(resource, "UTF-8"));
            if (this.clientId != null) {
                payload.append("&client_id=");
                payload.append(URLEncoder.encode(this.clientId, "UTF-8"));
            }
        }
        catch (IOException exception) {
            return Mono.error((Throwable)exception);
        }
        return this.checkIMDSAvailable().flatMap(available -> Mono.fromCallable(() -> {
            int retry = 1;
            while (retry <= this.options.getMaxRetry()) {
                URL url = null;
                HttpURLConnection connection = null;
                try {
                    url = new URL(String.format("http://169.254.169.254/metadata/identity/oauth2/token?%s", payload.toString()));
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("Metadata", "true");
                    connection.connect();
                    Scanner s = new Scanner(connection.getInputStream(), StandardCharsets.UTF_8.name()).useDelimiter("\\A");
                    String result = s.hasNext() ? s.next() : "";
                    MSIToken msiToken = (MSIToken)((Object)((Object)((Object)SERIALIZER_ADAPTER.deserialize(result, MSIToken.class, SerializerEncoding.JSON))));
                    IdentityToken identityToken = new IdentityToken(msiToken.getToken(), msiToken.getExpiresAt(), this.options);
                    return identityToken;
                }
                catch (IOException exception) {
                    if (connection == null) {
                        throw this.logger.logExceptionAsError(new RuntimeException(String.format("Could not connect to the url: %s.", url), exception));
                    }
                    int responseCode = connection.getResponseCode();
                    if (responseCode == 410 || responseCode == 429 || responseCode == 404 || responseCode >= 500 && responseCode <= 599) {
                        int retryTimeoutInMs = this.options.getRetryTimeout().apply(Duration.ofSeconds(RANDOM.nextInt(retry))).getNano() / 1000;
                        int n = retryTimeoutInMs = responseCode == 410 && retryTimeoutInMs < 70000 ? 70000 : retryTimeoutInMs;
                        if (++retry > this.options.getMaxRetry()) break;
                        IdentityClient.sleep(retryTimeoutInMs);
                        continue;
                    }
                    throw this.logger.logExceptionAsError(new RuntimeException("Couldn't acquire access token from IMDS, verify your objectId, clientId or msiResourceId", exception));
                }
                finally {
                    if (connection == null) continue;
                    connection.disconnect();
                }
            }
            throw this.logger.logExceptionAsError(new RuntimeException(String.format("MSI: Failed to acquire tokens after retrying %s times", this.options.getMaxRetry())));
        }));
    }

    private Mono<Boolean> checkIMDSAvailable() {
        StringBuilder payload = new StringBuilder();
        try {
            payload.append("api-version=");
            payload.append(URLEncoder.encode("2018-02-01", "UTF-8"));
        }
        catch (IOException exception) {
            return Mono.error((Throwable)exception);
        }
        return Mono.fromCallable(() -> {
            HttpURLConnection connection = null;
            URL url = new URL(String.format("http://169.254.169.254/metadata/identity/oauth2/token?%s", payload.toString()));
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(500);
                connection.connect();
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return true;
        });
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Proxy proxyOptionsToJavaNetProxy(ProxyOptions options) {
        switch (options.getType()) {
            case SOCKS4: 
            case SOCKS5: {
                return new Proxy(Proxy.Type.SOCKS, options.getAddress());
            }
        }
        return new Proxy(Proxy.Type.HTTP, options.getAddress());
    }

    private String getSafeWorkingDirectory() {
        if (this.isWindowsPlatform()) {
            if (CoreUtils.isNullOrEmpty((CharSequence)DEFAULT_WINDOWS_SYSTEM_ROOT)) {
                return null;
            }
            return DEFAULT_WINDOWS_SYSTEM_ROOT + "\\system32";
        }
        return DEFAULT_MAC_LINUX_PATH;
    }

    private boolean isWindowsPlatform() {
        return System.getProperty("os.name").contains("Windows");
    }

    private String redactInfo(String regex, String input) {
        return input.replaceAll(regex, "****");
    }

    void openUrl(String url) throws IOException {
        Runtime rt = Runtime.getRuntime();
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (os.contains("win")) {
            rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else if (os.contains("mac")) {
            rt.exec("open " + url);
        } else if (os.contains("nix") || os.contains("nux")) {
            rt.exec("xdg-open " + url);
        } else {
            this.logger.error("Browser could not be opened - please open {} in a browser on this device.", new Object[]{url});
        }
    }
}

