/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.Configuration;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public final class IdentityClientOptions {
    private static final int MAX_RETRY_DEFAULT_LIMIT = 3;
    private String authorityHost;
    private int maxRetry;
    private Function<Duration, Duration> retryTimeout;
    private ProxyOptions proxyOptions;
    private HttpPipeline httpPipeline;
    private ExecutorService executorService;
    private Duration tokenRefreshOffset = Duration.ofMinutes(2L);
    private HttpClient httpClient;

    public IdentityClientOptions() {
        Configuration configuration = Configuration.getGlobalConfiguration();
        this.authorityHost = (String)configuration.get("AZURE_AUTHORITY_HOST", (Object)"https://login.microsoftonline.com/");
        this.maxRetry = 3;
        this.retryTimeout = i -> Duration.ofSeconds((long)Math.pow(2.0, i.getSeconds() - 1L));
    }

    public String getAuthorityHost() {
        return this.authorityHost;
    }

    public IdentityClientOptions setAuthorityHost(String authorityHost) {
        this.authorityHost = authorityHost;
        return this;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public IdentityClientOptions setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
        return this;
    }

    public Function<Duration, Duration> getRetryTimeout() {
        return this.retryTimeout;
    }

    public IdentityClientOptions setRetryTimeout(Function<Duration, Duration> retryTimeout) {
        this.retryTimeout = retryTimeout;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public IdentityClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public IdentityClientOptions setHttpPipeline(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        return this;
    }

    public IdentityClientOptions setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Duration getTokenRefreshOffset() {
        return this.tokenRefreshOffset;
    }

    public IdentityClientOptions setTokenRefreshOffset(Duration tokenRefreshOffset) {
        Objects.requireNonNull(tokenRefreshOffset, "The token refresh offset cannot be null.");
        this.tokenRefreshOffset = tokenRefreshOffset;
        return this;
    }

    public IdentityClientOptions setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }
}

