/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.IntelliJCredential;
import com.azure.identity.VisualStudioCodeCredentialBuilder;

public class IntelliJCredentialBuilder
extends CredentialBuilderBase<VisualStudioCodeCredentialBuilder> {
    private String tenantId;
    private final ClientLogger logger = new ClientLogger(IntelliJCredentialBuilder.class);

    public IntelliJCredentialBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public IntelliJCredentialBuilder keePassDatabasePath(String databasePath) {
        if (CoreUtils.isNullOrEmpty((CharSequence)databasePath)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The KeePass database path is either empty or not configured. Please configure it on the builder."));
        }
        this.identityClientOptions.setIntelliJKeePassDatabasePath(databasePath);
        return this;
    }

    public IntelliJCredential build() {
        return new IntelliJCredential(this.tenantId, this.identityClientOptions);
    }
}

