/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.AuthenticationRecord;
import com.azure.identity.InteractiveBrowserCredential;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.HashMap;
import java.util.Map;

public class InteractiveBrowserCredentialBuilder
extends AadCredentialBuilderBase<InteractiveBrowserCredentialBuilder> {
    private int port;
    private boolean automaticAuthentication = true;

    public InteractiveBrowserCredentialBuilder port(int port) {
        this.port = port;
        return this;
    }

    public InteractiveBrowserCredentialBuilder allowUnencryptedCache() {
        this.identityClientOptions.allowUnencryptedCache();
        return this;
    }

    public InteractiveBrowserCredentialBuilder enablePersistentCache() {
        this.identityClientOptions.enablePersistentCache();
        return this;
    }

    public InteractiveBrowserCredentialBuilder authenticationRecord(AuthenticationRecord authenticationRecord) {
        this.identityClientOptions.setAuthenticationRecord(authenticationRecord);
        return this;
    }

    public InteractiveBrowserCredentialBuilder disableAutomaticAuthentication() {
        this.automaticAuthentication = false;
        return this;
    }

    public InteractiveBrowserCredential build() {
        ValidationUtil.validate(this.getClass().getSimpleName(), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("clientId", InteractiveBrowserCredentialBuilder.this.clientId);
                this.put("port", InteractiveBrowserCredentialBuilder.this.port);
            }
        });
        return new InteractiveBrowserCredential(this.clientId, this.tenantId, this.port, this.automaticAuthentication, this.identityClientOptions);
    }
}

