/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AuthenticationRecord;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.MsalAuthenticationAccount;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.util.LoggingUtil;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public class SharedTokenCacheCredential
implements TokenCredential {
    private final String username;
    private final String clientId;
    private final String tenantId;
    private final AtomicReference<MsalAuthenticationAccount> cachedToken;
    private final IdentityClient identityClient;
    private final ClientLogger logger = new ClientLogger(SharedTokenCacheCredential.class);

    SharedTokenCacheCredential(String username, String clientId, String tenantId, IdentityClientOptions identityClientOptions) {
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.username = username == null ? configuration.get("AZURE_USERNAME") : username;
        this.clientId = clientId == null ? configuration.get("AZURE_CLIENT_ID") : clientId;
        this.tenantId = tenantId == null ? (configuration.contains("AZURE_TENANT_ID") ? configuration.get("AZURE_TENANT_ID") : "common") : tenantId;
        this.identityClient = new IdentityClientBuilder().tenantId(this.tenantId).clientId(this.clientId).sharedTokenCacheCredential(true).identityClientOptions(identityClientOptions).build();
        this.cachedToken = new AtomicReference();
        if (identityClientOptions.getAuthenticationRecord() != null) {
            this.cachedToken.set(new MsalAuthenticationAccount(identityClientOptions.getAuthenticationRecord()));
        }
        LoggingUtil.logAvailableEnvironmentVariables(this.logger, configuration);
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithPublicClientCache(request, this.cachedToken.get()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithSharedTokenCache(request, this.username))).map(this::updateCache).doOnNext(token -> LoggingUtil.logTokenSuccess(this.logger, request)).doOnError(error -> LoggingUtil.logTokenError(this.logger, request, error));
    }

    private AccessToken updateCache(MsalToken msalToken) {
        this.cachedToken.set(new MsalAuthenticationAccount(new AuthenticationRecord(msalToken.getAuthenticationResult(), this.identityClient.getTenantId(), this.identityClient.getClientId())));
        return msalToken;
    }
}

