/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.Configuration;
import com.azure.identity.AuthenticationRecord;
import com.microsoft.aad.msal4jextensions.PersistenceSettings;
import com.sun.jna.Platform;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public final class IdentityClientOptions {
    private static final int MAX_RETRY_DEFAULT_LIMIT = 3;
    private static final String DEFAULT_PUBLIC_CACHE_FILE_NAME = "msal.cache";
    private static final String DEFAULT_CONFIDENTIAL_CACHE_FILE_NAME = "msal.confidential.cache";
    private static final Path DEFAULT_CACHE_FILE_PATH = Platform.isWindows() ? Paths.get(System.getProperty("user.home"), "AppData", "Local", ".IdentityService") : Paths.get(System.getProperty("user.home"), ".IdentityService");
    private static final String DEFAULT_KEYCHAIN_SERVICE = "Microsoft.Developer.IdentityService";
    private static final String DEFAULT_PUBLIC_KEYCHAIN_ACCOUNT = "MSALCache";
    private static final String DEFAULT_CONFIDENTIAL_KEYCHAIN_ACCOUNT = "MSALConfidentialCache";
    private static final String DEFAULT_KEYRING_NAME = "default";
    private static final String DEFAULT_KEYRING_SCHEMA = "msal.cache";
    private static final String DEFAULT_PUBLIC_KEYRING_ITEM_NAME = "MSALCache";
    private static final String DEFAULT_CONFIDENTIAL_KEYRING_ITEM_NAME = "MSALConfidentialCache";
    private static final String DEFAULT_KEYRING_ATTR_NAME = "MsalClientID";
    private static final String DEFAULT_KEYRING_ATTR_VALUE = "Microsoft.Developer.IdentityService";
    private String authorityHost;
    private int maxRetry;
    private Function<Duration, Duration> retryTimeout;
    private ProxyOptions proxyOptions;
    private HttpPipeline httpPipeline;
    private ExecutorService executorService;
    private HttpClient httpClient;
    private boolean allowUnencryptedCache;
    private boolean sharedTokenCacheEnabled;
    private String keePassDatabasePath;
    private AuthenticationRecord authenticationRecord;

    public IdentityClientOptions() {
        Configuration configuration = Configuration.getGlobalConfiguration();
        this.authorityHost = (String)configuration.get("AZURE_AUTHORITY_HOST", (Object)"https://login.microsoftonline.com/");
        this.maxRetry = 3;
        this.retryTimeout = i -> Duration.ofSeconds((long)Math.pow(2.0, i.getSeconds() - 1L));
    }

    public String getAuthorityHost() {
        return this.authorityHost;
    }

    public IdentityClientOptions setAuthorityHost(String authorityHost) {
        this.authorityHost = authorityHost;
        return this;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public IdentityClientOptions setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
        return this;
    }

    public Function<Duration, Duration> getRetryTimeout() {
        return this.retryTimeout;
    }

    public IdentityClientOptions setRetryTimeout(Function<Duration, Duration> retryTimeout) {
        this.retryTimeout = retryTimeout;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public IdentityClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public IdentityClientOptions setHttpPipeline(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        return this;
    }

    public IdentityClientOptions setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public IdentityClientOptions setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    PersistenceSettings getPublicClientPersistenceSettings() {
        return PersistenceSettings.builder((String)"msal.cache", (Path)DEFAULT_CACHE_FILE_PATH).setMacKeychain("Microsoft.Developer.IdentityService", "MSALCache").setLinuxKeyring(DEFAULT_KEYRING_NAME, "msal.cache", "MSALCache", DEFAULT_KEYRING_ATTR_NAME, "Microsoft.Developer.IdentityService", null, null).setLinuxUseUnprotectedFileAsCacheStorage(this.allowUnencryptedCache).build();
    }

    PersistenceSettings getConfidentialClientPersistenceSettings() {
        return PersistenceSettings.builder((String)DEFAULT_CONFIDENTIAL_CACHE_FILE_NAME, (Path)DEFAULT_CACHE_FILE_PATH).setMacKeychain("Microsoft.Developer.IdentityService", "MSALConfidentialCache").setLinuxKeyring(DEFAULT_KEYRING_NAME, "msal.cache", "MSALConfidentialCache", DEFAULT_KEYRING_ATTR_NAME, "Microsoft.Developer.IdentityService", null, null).setLinuxUseUnprotectedFileAsCacheStorage(this.allowUnencryptedCache).build();
    }

    public IdentityClientOptions allowUnencryptedCache() {
        this.allowUnencryptedCache = true;
        return this;
    }

    public IdentityClientOptions setIntelliJKeePassDatabasePath(String keePassDatabasePath) {
        this.keePassDatabasePath = keePassDatabasePath;
        return this;
    }

    public boolean isSharedTokenCacheEnabled() {
        return this.sharedTokenCacheEnabled;
    }

    public IdentityClientOptions enablePersistentCache() {
        this.sharedTokenCacheEnabled = true;
        return this;
    }

    public String getIntelliJKeePassDatabasePath() {
        return this.keePassDatabasePath;
    }

    public IdentityClientOptions setAuthenticationRecord(AuthenticationRecord authenticationRecord) {
        this.authenticationRecord = authenticationRecord;
        return this;
    }

    public AuthenticationRecord getAuthenticationRecord() {
        return this.authenticationRecord;
    }
}

