/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.ManagedIdentityCredential;

public class ManagedIdentityCredentialBuilder
extends CredentialBuilderBase<ManagedIdentityCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedIdentityCredentialBuilder.class);
    private String clientId;
    private String resourceId;

    public ManagedIdentityCredentialBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public ManagedIdentityCredentialBuilder resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public ManagedIdentityCredential build() {
        if (this.clientId != null && this.resourceId != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Only one of clientId and resourceId can be specified."));
        }
        return new ManagedIdentityCredential(this.clientId, this.resourceId, this.identityClientOptions);
    }
}

