/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.ClientAssertionCredentialHelper;
import com.azure.identity.implementation.IdentityClientBase;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.models.OidcTokenResponse;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import java.io.IOException;
import java.net.URL;
import reactor.core.publisher.Mono;

public class AzurePipelinesCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AzurePipelinesCredential.class);
    private final ClientAssertionCredentialHelper clientAssertionCredentialHelper;

    AzurePipelinesCredential(String clientId, String tenantId, String requestUrl, String systemAccessToken, IdentityClientOptions identityClientOptions) {
        this.clientAssertionCredentialHelper = new ClientAssertionCredentialHelper(clientId, tenantId, identityClientOptions, () -> {
            HttpClient client = identityClientOptions.getHttpClient();
            if (client == null) {
                HttpClient.createDefault();
            }
            HttpPipeline pipeline = IdentityClientBase.setupPipeline(client, identityClientOptions);
            try {
                URL url = new URL(requestUrl);
                HttpRequest request = new HttpRequest(HttpMethod.POST, url);
                request.setHeader(HttpHeaderName.AUTHORIZATION, "Bearer " + systemAccessToken);
                request.setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
                try (HttpResponse response = pipeline.sendSync(request, Context.NONE);){
                    String string;
                    block16: {
                        String responseBody = response.getBodyAsBinaryData().toString();
                        if (response.getStatusCode() != 200) {
                            throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Failed to get the client assertion token " + responseBody + System.lineSeparator() + "For troubleshooting information see https://aka.ms/azsdk/java/identity/azurepipelinescredential/troubleshoot.", response));
                        }
                        JsonReader reader = JsonProviders.createReader((String)responseBody);
                        try {
                            string = OidcTokenResponse.fromJson(reader).getOidcToken();
                            if (reader == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        reader.close();
                    }
                    return string;
                }
            }
            catch (IOException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Failed to get the client assertion token", null, (Throwable)e));
            }
        });
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return this.clientAssertionCredentialHelper.getToken(request);
    }

    public AccessToken getTokenSync(TokenRequestContext request) {
        return this.clientAssertionCredentialHelper.getTokenSync(request);
    }
}

