/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.AzurePipelinesCredential;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.Arrays;

public class AzurePipelinesCredentialBuilder
extends AadCredentialBuilderBase<AzurePipelinesCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(AzurePipelinesCredentialBuilder.class);
    private static final String OIDC_API_VERSION = "7.1";
    private String serviceConnectionId;
    private String systemAccessToken;

    public AzurePipelinesCredentialBuilder serviceConnectionId(String serviceConnectionId) {
        this.serviceConnectionId = serviceConnectionId;
        return this;
    }

    public AzurePipelinesCredentialBuilder systemAccessToken(String systemAccessToken) {
        this.systemAccessToken = systemAccessToken;
        return this;
    }

    public AzurePipelinesCredential build() {
        Configuration configuration = this.identityClientOptions.getConfiguration();
        if (configuration == null) {
            configuration = Configuration.getGlobalConfiguration();
        }
        String oidcEndpoint = configuration.get("SYSTEM_OIDCREQUESTURI");
        ValidationUtil.validate(this.getClass().getSimpleName(), LOGGER, Arrays.asList("clientId", "tenantId", "serviceConnectionId", "systemAccessToken", "oidcEndpoint"), Arrays.asList(this.clientId, this.tenantId, this.serviceConnectionId, this.systemAccessToken, oidcEndpoint));
        String requestUrl = String.format("%s?api-version=%s&serviceConnectionId=%s", oidcEndpoint, OIDC_API_VERSION, this.serviceConnectionId);
        return new AzurePipelinesCredential(this.clientId, this.tenantId, requestUrl, this.systemAccessToken, this.identityClientOptions.clone());
    }
}

