/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AksExchangeTokenCredential;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.ManagedIdentityMsalCredential;
import com.azure.identity.ManagedIdentityServiceCredential;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.ManagedIdentityParameters;
import com.azure.identity.implementation.ManagedIdentityType;
import com.azure.identity.implementation.util.LoggingUtil;
import com.microsoft.aad.msal4j.ManagedIdentityApplication;
import com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class ManagedIdentityCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedIdentityCredential.class);
    final ManagedIdentityServiceCredential managedIdentityServiceCredential;
    private final IdentityClientOptions identityClientOptions;
    private final String managedIdentityId;
    static final String PROPERTY_IMDS_ENDPOINT = "IMDS_ENDPOINT";
    static final String PROPERTY_IDENTITY_SERVER_THUMBPRINT = "IDENTITY_SERVER_THUMBPRINT";
    static final String AZURE_FEDERATED_TOKEN_FILE = "AZURE_FEDERATED_TOKEN_FILE";
    static final String USE_AZURE_IDENTITY_CLIENT_LIBRARY_LEGACY_MI = "USE_AZURE_IDENTITY_CLIENT_LIBRARY_LEGACY_MI";

    ManagedIdentityCredential(String clientId, String resourceId, String objectId, IdentityClientOptions identityClientOptions) {
        IdentityClientBuilder clientBuilder = new IdentityClientBuilder().clientId(clientId).resourceId(resourceId).objectId(objectId).identityClientOptions(identityClientOptions);
        this.identityClientOptions = identityClientOptions;
        Configuration configuration = identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : identityClientOptions.getConfiguration();
        this.managedIdentityId = this.fetchManagedIdentityId(clientId, resourceId, objectId);
        if (configuration.contains("AZURE_TENANT_ID") && configuration.get(AZURE_FEDERATED_TOKEN_FILE) != null) {
            String clientIdentifier = clientId == null ? configuration.get("AZURE_CLIENT_ID") : clientId;
            clientBuilder.clientId(clientIdentifier);
            clientBuilder.tenantId(configuration.get("AZURE_TENANT_ID"));
            clientBuilder.clientAssertionPath(configuration.get(AZURE_FEDERATED_TOKEN_FILE));
            clientBuilder.clientAssertionTimeout(Duration.ofMinutes(5L));
            this.managedIdentityServiceCredential = new AksExchangeTokenCredential(clientIdentifier, clientBuilder.identityClientOptions(this.updateIdentityClientOptions(ManagedIdentityType.AKS, identityClientOptions, configuration)).build());
        } else {
            identityClientOptions.setManagedIdentityType(this.getManagedIdentityEnv(configuration));
            this.managedIdentityServiceCredential = new ManagedIdentityMsalCredential(clientId, clientBuilder.build());
        }
        LoggingUtil.logAvailableEnvironmentVariables(LOGGER, configuration);
    }

    private IdentityClientOptions updateIdentityClientOptions(ManagedIdentityType managedIdentityType, IdentityClientOptions clientOptions, Configuration configuration) {
        switch (managedIdentityType) {
            case APP_SERVICE: {
                return clientOptions.setManagedIdentityType(ManagedIdentityType.APP_SERVICE).setManagedIdentityParameters(new ManagedIdentityParameters().setMsiEndpoint(configuration.get("MSI_ENDPOINT")).setMsiSecret(configuration.get("MSI_SECRET")).setIdentityEndpoint(configuration.get("IDENTITY_ENDPOINT")).setIdentityHeader(configuration.get("IDENTITY_HEADER")));
            }
            case SERVICE_FABRIC: {
                return clientOptions.setManagedIdentityType(ManagedIdentityType.SERVICE_FABRIC).setManagedIdentityParameters(new ManagedIdentityParameters().setIdentityServerThumbprint(configuration.get(PROPERTY_IDENTITY_SERVER_THUMBPRINT)).setIdentityEndpoint(configuration.get("IDENTITY_ENDPOINT")).setIdentityHeader(configuration.get("IDENTITY_HEADER")));
            }
            case ARC: {
                return clientOptions.setManagedIdentityType(ManagedIdentityType.ARC).setManagedIdentityParameters(new ManagedIdentityParameters().setIdentityEndpoint(configuration.get("IDENTITY_ENDPOINT")));
            }
            case VM: {
                return clientOptions.setManagedIdentityType(ManagedIdentityType.VM);
            }
            case AKS: {
                return clientOptions.setManagedIdentityType(ManagedIdentityType.AKS);
            }
        }
        return clientOptions;
    }

    public String getClientId() {
        return this.managedIdentityServiceCredential.getClientId();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        if (this.managedIdentityServiceCredential == null) {
            return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. The Target Azure platform could not be determined from environment variables.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/managedidentitycredential/troubleshoot"))));
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)this.managedIdentityId)) {
            ManagedIdentitySourceType managedIdentitySourceType = ManagedIdentityApplication.getManagedIdentitySource();
            if (ManagedIdentitySourceType.CLOUD_SHELL.equals((Object)managedIdentitySourceType) || ManagedIdentitySourceType.AZURE_ARC.equals((Object)managedIdentitySourceType)) {
                return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. User-assigned managed identity is not supported in " + managedIdentitySourceType + ". To use system-assigned managed identity, remove the configured client ID on the " + (this.identityClientOptions.isChained() ? "DefaultAzureCredentialBuilder." : "ManagedIdentityCredentialBuilder.")))));
            }
            LOGGER.info("User-assigned Managed Identity ID: " + this.getClientId());
        }
        return this.managedIdentityServiceCredential.authenticate(request).doOnSuccess(t -> LOGGER.info("Azure Identity => Managed Identity environment: {}", new Object[]{this.managedIdentityServiceCredential.getEnvironment()})).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClientOptions, request, error));
    }

    ManagedIdentityType getManagedIdentityEnv(Configuration configuration) {
        if (configuration.contains("MSI_ENDPOINT")) {
            return ManagedIdentityType.APP_SERVICE;
        }
        if (configuration.contains("IDENTITY_ENDPOINT")) {
            if (configuration.contains("IDENTITY_HEADER")) {
                if (configuration.get(PROPERTY_IDENTITY_SERVER_THUMBPRINT) != null) {
                    return ManagedIdentityType.SERVICE_FABRIC;
                }
                return ManagedIdentityType.APP_SERVICE;
            }
            if (configuration.get(PROPERTY_IMDS_ENDPOINT) != null) {
                return ManagedIdentityType.ARC;
            }
            return ManagedIdentityType.VM;
        }
        if (configuration.contains("AZURE_TENANT_ID") && configuration.get(AZURE_FEDERATED_TOKEN_FILE) != null) {
            return ManagedIdentityType.AKS;
        }
        return ManagedIdentityType.VM;
    }

    String fetchManagedIdentityId(String clientId, String resourceId, String objectId) {
        if (clientId != null) {
            return clientId;
        }
        if (resourceId != null) {
            return resourceId;
        }
        if (objectId != null) {
            return objectId;
        }
        return null;
    }
}

