/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.ClientAssertionCredential;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.util.LoggingUtil;
import com.azure.identity.implementation.util.ValidationUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import reactor.core.publisher.Mono;

public class WorkloadIdentityCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(WorkloadIdentityCredential.class);
    private final ClientAssertionCredential clientAssertionCredential;
    private final IdentityClientOptions identityClientOptions;
    private final String clientId;

    WorkloadIdentityCredential(String tenantId, String clientId, String federatedTokenFilePath, IdentityClientOptions identityClientOptions) {
        ValidationUtil.validateTenantIdCharacterRange(tenantId, LOGGER);
        Configuration configuration = identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : identityClientOptions.getConfiguration();
        String tenantIdInput = CoreUtils.isNullOrEmpty((CharSequence)tenantId) ? configuration.get("AZURE_TENANT_ID") : tenantId;
        String federatedTokenFilePathInput = CoreUtils.isNullOrEmpty((CharSequence)federatedTokenFilePath) ? configuration.get("AZURE_FEDERATED_TOKEN_FILE") : federatedTokenFilePath;
        String clientIdInput = CoreUtils.isNullOrEmpty((CharSequence)clientId) ? configuration.get("AZURE_CLIENT_ID") : clientId;
        ClientAssertionCredential tempClientAssertionCredential = null;
        String tempClientId = null;
        if (!(CoreUtils.isNullOrEmpty((CharSequence)tenantIdInput) || CoreUtils.isNullOrEmpty((CharSequence)federatedTokenFilePathInput) || CoreUtils.isNullOrEmpty((CharSequence)clientIdInput) || CoreUtils.isNullOrEmpty((CharSequence)identityClientOptions.getAuthorityHost()))) {
            try {
                tempClientAssertionCredential = this.buildClientAssertionCredential(tenantIdInput, clientIdInput, federatedTokenFilePathInput, identityClientOptions);
                tempClientId = clientIdInput;
            }
            catch (Exception e) {
                LOGGER.atVerbose().log("Failed to build ClientAssertionCredential during construction", new Object[]{e});
            }
        }
        this.clientAssertionCredential = tempClientAssertionCredential;
        this.clientId = tempClientId;
        this.identityClientOptions = identityClientOptions;
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        if (this.clientAssertionCredential == null) {
            return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("WorkloadIdentityCredential authentication unavailable. The workload options are not fully configured. See the troubleshooting guide for more information. https://aka.ms/azsdk/java/identity/workloadidentitycredential/troubleshoot"))));
        }
        return this.clientAssertionCredential.getToken(request);
    }

    public AccessToken getTokenSync(TokenRequestContext request) {
        if (this.clientAssertionCredential == null) {
            throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("WorkloadIdentityCredential authentication unavailable. The workload options are not fully configured. See the troubleshooting guide for more information. https://aka.ms/azsdk/java/identity/workloadidentitycredential/troubleshoot"));
        }
        return this.clientAssertionCredential.getTokenSync(request);
    }

    String getClientId() {
        return this.clientId;
    }

    private ClientAssertionCredential buildClientAssertionCredential(String tenantId, String clientId, String federatedTokenFilePath, IdentityClientOptions identityClientOptions) {
        ClientAssertionCredential credential = new ClientAssertionCredential(clientId, tenantId, () -> this.readFederatedTokenFromFile(federatedTokenFilePath), identityClientOptions);
        return credential;
    }

    private String readFederatedTokenFromFile(String filePath) {
        if (filePath == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Federated token file path cannot be null"));
        }
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
            return new String(bytes, StandardCharsets.UTF_8).trim();
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to read federated token from file. ", e));
        }
    }
}

