/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.customtokenproxy;

import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.customtokenproxy.ProxyConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public final class CustomTokenProxyConfiguration {
    private static final ClientLogger LOGGER = new ClientLogger(CustomTokenProxyConfiguration.class);
    private static final String AZURE_KUBERNETES_TOKEN_PROXY = "AZURE_KUBERNETES_TOKEN_PROXY";
    private static final String AZURE_KUBERNETES_CA_FILE = "AZURE_KUBERNETES_CA_FILE";
    private static final String AZURE_KUBERNETES_CA_DATA = "AZURE_KUBERNETES_CA_DATA";
    private static final String AZURE_KUBERNETES_SNI_NAME = "AZURE_KUBERNETES_SNI_NAME";

    private CustomTokenProxyConfiguration() {
    }

    public static ProxyConfig parseAndValidate(Configuration configuration) {
        String tokenProxyUrl = configuration.get(AZURE_KUBERNETES_TOKEN_PROXY);
        String caFile = configuration.get(AZURE_KUBERNETES_CA_FILE);
        String caData = configuration.get(AZURE_KUBERNETES_CA_DATA);
        String sniName = configuration.get(AZURE_KUBERNETES_SNI_NAME);
        if (CoreUtils.isNullOrEmpty((CharSequence)tokenProxyUrl)) {
            if (!(CoreUtils.isNullOrEmpty((CharSequence)sniName) && CoreUtils.isNullOrEmpty((CharSequence)caFile) && CoreUtils.isNullOrEmpty((CharSequence)caData))) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("AZURE_KUBERNETES_TOKEN_PROXY is not set but other custom endpoint-related environment variables are present"));
            }
            return null;
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)caFile) && !CoreUtils.isNullOrEmpty((CharSequence)caData)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Only one of AZURE_KUBERNETES_CA_FILE or AZURE_KUBERNETES_CA_DATA can be set."));
        }
        URL proxyUrl = CustomTokenProxyConfiguration.validateProxyUrl(tokenProxyUrl);
        byte[] caCertBytes = null;
        if (!CoreUtils.isNullOrEmpty((CharSequence)caData)) {
            caCertBytes = caData.getBytes(StandardCharsets.UTF_8);
        }
        ProxyConfig config = new ProxyConfig(proxyUrl, sniName, caFile, caCertBytes);
        return config;
    }

    private static URL validateProxyUrl(String endpoint) {
        if (CoreUtils.isNullOrEmpty((CharSequence)endpoint)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Proxy endpoint cannot be null or empty"));
        }
        try {
            URI tokenProxy = new URI(endpoint);
            if (!"https".equals(tokenProxy.getScheme())) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Custom token endpoint must use https scheme, got: " + tokenProxy.getScheme()));
            }
            if (tokenProxy.getRawUserInfo() != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Custom token endpoint URL must not contain user info: " + endpoint));
            }
            if (tokenProxy.getRawQuery() != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Custom token endpoint URL must not contain a query: " + endpoint));
            }
            if (tokenProxy.getRawFragment() != null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Custom token endpoint URL must not contain a fragment: " + endpoint));
            }
            if (tokenProxy.getRawPath() == null || tokenProxy.getRawPath().isEmpty()) {
                tokenProxy = new URI(tokenProxy.getScheme(), null, tokenProxy.getHost(), tokenProxy.getPort(), "/", null, null);
            }
            return tokenProxy.toURL();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Failed to normalize proxy URL path", e));
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while validating proxy URL: " + endpoint, e);
        }
    }
}

