/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientOptions;
import java.io.InputStream;

public final class IdentityClientBuilder {
    private IdentityClientOptions identityClientOptions;
    private String tenantId;
    private String clientId;
    private String clientSecret;
    private String certificatePath;
    private InputStream certificate;
    private String certificatePassword;
    private boolean sharedTokenCacheCred;

    public IdentityClientBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public IdentityClientBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public IdentityClientBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public IdentityClientBuilder certificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
        return this;
    }

    public IdentityClientBuilder certificate(InputStream certificate) {
        this.certificate = certificate;
        return this;
    }

    public IdentityClientBuilder certificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
        return this;
    }

    public IdentityClientBuilder identityClientOptions(IdentityClientOptions identityClientOptions) {
        this.identityClientOptions = identityClientOptions;
        return this;
    }

    public IdentityClientBuilder sharedTokenCacheCredential(boolean isSharedTokenCacheCred) {
        this.sharedTokenCacheCred = isSharedTokenCacheCred;
        return this;
    }

    public IdentityClient build() {
        return new IdentityClient(this.tenantId, this.clientId, this.clientSecret, this.certificatePath, this.certificate, this.certificatePassword, this.sharedTokenCacheCred, this.identityClientOptions);
    }
}

