/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.implementation.LinuxKeyRingAccessor;
import com.azure.identity.implementation.WindowsCredentialAccessor;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.msal4jextensions.persistence.mac.KeyChainAccessor;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class VisualStudioCacheAccessor {
    private static final String PLATFORM_NOT_SUPPORTED_ERROR = "Platform could not be determined for VS Code credential authentication.";
    private final ClientLogger logger = new ClientLogger(VisualStudioCacheAccessor.class);
    private static final Pattern REFRESH_TOKEN_PATTERN = Pattern.compile("^[-_.a-zA-Z0-9]+$");

    private JsonNode getUserSettings() {
        JsonNode output = null;
        String homeDir = System.getProperty("user.home");
        String settingsPath = "";
        try {
            if (Platform.isWindows()) {
                settingsPath = Paths.get(System.getenv("APPDATA"), "Code", "User", "settings.json").toString();
            } else if (Platform.isMac()) {
                settingsPath = Paths.get(homeDir, "Library", "Application Support", "Code", "User", "settings.json").toString();
            } else if (Platform.isLinux()) {
                settingsPath = Paths.get(homeDir, ".config", "Code", "User", "settings.json").toString();
            } else {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException(PLATFORM_NOT_SUPPORTED_ERROR)));
            }
            output = this.readJsonFile(settingsPath);
        }
        catch (Exception e) {
            return null;
        }
        return output;
    }

    JsonNode readJsonFile(String path) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
        mapper.configure(JsonReadFeature.ALLOW_JAVA_COMMENTS.mappedFeature(), true);
        mapper.configure(JsonReadFeature.ALLOW_TRAILING_COMMA.mappedFeature(), true);
        File settingsFile = new File(path);
        return mapper.readTree(settingsFile);
    }

    public Map<String, String> getUserSettingsDetails() {
        JsonNode userSettings = this.getUserSettings();
        HashMap<String, String> details = new HashMap<String, String>();
        String tenant = null;
        String cloud = "AzureCloud";
        if (userSettings != null && !userSettings.isNull()) {
            if (userSettings.has("azure.tenant")) {
                tenant = userSettings.get("azure.tenant").asText();
            }
            if (userSettings.has("azure.cloud")) {
                cloud = userSettings.get("azure.cloud").asText();
            }
        }
        if (!CoreUtils.isNullOrEmpty(tenant)) {
            details.put("tenant", tenant);
        }
        details.put("cloud", cloud);
        return details;
    }

    public String getCredentials(String serviceName, String accountName) {
        String credential;
        if (Platform.isWindows()) {
            try {
                WindowsCredentialAccessor winCredAccessor = new WindowsCredentialAccessor(serviceName, accountName);
                credential = winCredAccessor.read();
            }
            catch (Error | Exception e) {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("Failed to read Vs Code credentials from Windows Credential API.", e)));
            }
        } else if (Platform.isMac()) {
            try {
                KeyChainAccessor keyChainAccessor = new KeyChainAccessor(null, serviceName, accountName);
                byte[] readCreds = keyChainAccessor.read();
                credential = new String(readCreds, StandardCharsets.UTF_8);
            }
            catch (Error | Exception e) {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("Failed to read Vs Code credentials from Mac Native Key Chain.", e)));
            }
        } else if (Platform.isLinux()) {
            try {
                LinuxKeyRingAccessor keyRingAccessor = new LinuxKeyRingAccessor("org.freedesktop.Secret.Generic", "service", serviceName, "account", accountName);
                byte[] readCreds = keyRingAccessor.read();
                credential = new String(readCreds, StandardCharsets.UTF_8);
            }
            catch (Error | Exception e) {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("Failed to read Vs Code credentials from Linux Key Ring.", e)));
            }
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException(PLATFORM_NOT_SUPPORTED_ERROR)));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)credential) || !this.isRefreshTokenString(credential)) {
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("Please authenticate via Azure Tools plugin in VS Code IDE.")));
        }
        return credential;
    }

    private boolean isRefreshTokenString(String str) {
        return REFRESH_TOKEN_PATTERN.matcher(str).matches();
    }

    public String getAzureAuthHost(String cloud) {
        switch (cloud) {
            case "AzureCloud": {
                return "https://login.microsoftonline.com/";
            }
            case "AzureChina": {
                return "https://login.chinacloudapi.cn/";
            }
            case "AzureGermanCloud": {
                return "https://login.microsoftonline.de/";
            }
            case "AzureUSGovernment": {
                return "https://login.microsoftonline.us/";
            }
        }
        return "https://login.microsoftonline.com/";
    }
}

